/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.cart;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.odfweb.cart.ODFCartManager;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ShareCartMailGenerator
extends ServiceableGenerator {
    private ODFCartManager _odfCartManager;
    private UserHelper _userHelper;
    private SiteManager _siteManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._odfCartManager = (ODFCartManager)((Object)smanager.lookup(ODFCartManager.ROLE));
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"Mail");
        Map ctxParameters = (Map)this.objectModel.get("parent-context");
        UserIdentity owner = (UserIdentity)ctxParameters.get("owner");
        String message = (String)ctxParameters.get("message");
        String siteName = (String)ctxParameters.get("siteName");
        List items = (List)ctxParameters.get("items");
        if (owner != null) {
            this._userHelper.saxUserIdentity(owner, this.contentHandler, "owner");
        }
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"message", (String)message);
        }
        Site site = this._siteManager.getSite(siteName);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"siteTitle", (String)site.getTitle());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"siteUrl", (String)site.getUrl());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"items");
        for (ODFCartManager.ODFCartItem item : items) {
            this._odfCartManager.saxCartItem(this.contentHandler, item, siteName);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"items");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"Mail");
        this.contentHandler.endDocument();
    }
}

