/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.clientside;

import com.google.common.collect.ObjectArrays;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.util.LambdaUtils;
import org.ametys.odf.catalog.Catalog;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.plugins.odfweb.repository.FirstLevelPageFactory;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.jackrabbit.value.StringValue;

public class ODFRootClientSideElement
extends StaticClientSideElement {
    protected AmetysObjectResolver _resolver;
    protected CatalogsManager _catalogsManager;
    protected OdfPageHandler _odfPageHandler;
    protected ObservationManager _observationManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._catalogsManager = (CatalogsManager)smanager.lookup(CatalogsManager.ROLE);
        this._odfPageHandler = (OdfPageHandler)((Object)smanager.lookup(OdfPageHandler.ROLE));
        this._observationManager = (ObservationManager)smanager.lookup(ObservationManager.ROLE);
    }

    @Callable(rights={"ODF_Rights_SetRootPage"})
    public Map<String, Object> getStatus(String pageId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Page page = (Page)this._resolver.resolveById(pageId);
        results.put("page-id", page.getId());
        if (page instanceof JCRAmetysObject) {
            if (this._odfPageHandler.isODFRootPage(page)) {
                results.put("is-odf-root", true);
                I18nizableText rawDescription = (I18nizableText)this._script.getParameters().get("odf-root-page-description");
                HashMap<String, I18nizableText> i18nParams = new HashMap<String, I18nizableText>();
                i18nParams.put("title", new I18nizableText(page.getTitle()));
                I18nizableText description = new I18nizableText(rawDescription.getCatalogue(), rawDescription.getKey(), i18nParams);
                results.put("odf-root-page-description", description);
                rawDescription = (I18nizableText)this._script.getParameters().get("remove-odf-page-description");
                description = new I18nizableText(rawDescription.getCatalogue(), rawDescription.getKey(), i18nParams);
                results.put("remove-odf-page-description", description);
                String catalogCode = (String)page.getValue("odf-root-catalog");
                if (StringUtils.isNotEmpty((CharSequence)catalogCode)) {
                    Catalog catalog = this._catalogsManager.getCatalog(catalogCode);
                    I18nizableText catalogText = new I18nizableText(catalog != null ? catalog.getTitle() : catalogCode);
                    i18nParams = new HashMap();
                    i18nParams.put("catalog", catalogText);
                    rawDescription = (I18nizableText)this._script.getParameters().get("catalog-description");
                    description = new I18nizableText(rawDescription.getCatalogue(), rawDescription.getKey(), i18nParams);
                    results.put("catalog-description", description);
                }
            } else {
                results.put("add-odf-page", true);
                I18nizableText rawDescription = (I18nizableText)this._script.getParameters().get("add-odf-page-description");
                HashMap<String, I18nizableText> i18nParams = new HashMap<String, I18nizableText>();
                i18nParams.put("title", new I18nizableText(page.getTitle()));
                I18nizableText description = new I18nizableText(rawDescription.getCatalogue(), rawDescription.getKey(), i18nParams);
                results.put("add-odf-page-description", description);
            }
        } else {
            results.put("invalid-page", true);
            I18nizableText rawDescription = (I18nizableText)this._script.getParameters().get("no-jcr-page-description");
            HashMap<String, I18nizableText> i18nParams = new HashMap<String, I18nizableText>();
            i18nParams.put("title", new I18nizableText(page.getTitle()));
            I18nizableText description = new I18nizableText(rawDescription.getCatalogue(), rawDescription.getKey(), i18nParams);
            results.put("no-jcr-page-description", description);
        }
        return results;
    }

    @Callable(rights={"ODF_Rights_SetRootPage"})
    public Map<String, Object> getOdfRootPageInfo(String pageId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Page page = (Page)this._resolver.resolveById(pageId);
        Set<Page> currentODFPages = this._odfPageHandler.getOdfRootPages(page.getSiteName(), page.getSitemapName());
        if (this._catalogsManager.getCatalogs().isEmpty()) {
            properties.put("noCatalog", true);
        }
        if (!currentODFPages.contains(page)) {
            properties.put("isOdfRootPage", false);
            properties.put("areChildrenIndexable", true);
        } else {
            properties.put("isOdfRootPage", true);
            properties.put("catalog", page.getValue("odf-root-catalog", (Object)""));
            properties.put("firstLevel", page.getValue("firstLevel", (Object)""));
            properties.put("secondLevel", page.getValue("secondLevel", (Object)""));
            properties.put("areChildrenIndexable", page.getValue("indexableChildren", (Object)true));
        }
        return properties;
    }

    @Callable(rights={"ODF_Rights_SetRootPage"})
    public boolean addOrUpdateOdfRootProperty(String pageId, String catalog, String firstLevel, String secondLevel, boolean areChildrenIndexable) throws RepositoryException {
        Page page = (Page)this._resolver.resolveById(pageId);
        Set<Page> currentODFPages = this._odfPageHandler.getOdfRootPages(page.getSiteName(), page.getSitemapName());
        if (!currentODFPages.contains(page)) {
            return this._addOdfRootProperty(page, catalog, firstLevel, secondLevel, areChildrenIndexable);
        }
        return this._updateOdfRootProperty(page, catalog, firstLevel, secondLevel, areChildrenIndexable);
    }

    private boolean _addOdfRootProperty(Page page, String catalog, String firstLevel, String secondLevel, boolean areChildrenIndexable) throws RepositoryException {
        boolean hasChanges = false;
        if (page instanceof JCRAmetysObject) {
            JCRAmetysObject jcrPage = (JCRAmetysObject)page;
            Property virtualProperty = this._getVirtualProperty(jcrPage);
            Object[] oldValues = virtualProperty != null ? virtualProperty.getValues() : new Value[]{};
            boolean hasVirtualProperty = Arrays.stream(oldValues).anyMatch(LambdaUtils.wrapPredicate(ODFRootClientSideElement::isVirtualPageFactoryValue));
            if (!hasVirtualProperty) {
                Value[] newValues = (Value[])ObjectArrays.concat((Object[])oldValues, (Object)new StringValue(FirstLevelPageFactory.class.getName()));
                this._setVirtualProperty(jcrPage, newValues);
            }
            hasChanges = this._updateOdfRootProperty(page, catalog, firstLevel, secondLevel, areChildrenIndexable);
        }
        if (hasChanges) {
            this._notifyOdfRootPageChange(page);
        }
        return hasChanges;
    }

    private boolean _updateOdfRootProperty(Page page, String catalog, String firstLevel, String secondLevel, boolean areChildrenIndexable) {
        boolean hasChanges = this._setOdfRootAttributes(page, catalog, firstLevel, secondLevel, areChildrenIndexable);
        if (hasChanges) {
            HashMap<String, Page> eventParams = new HashMap<String, Page>();
            eventParams.put("page", page);
            this._observationManager.notify(new Event("odf.root.updated", this._currentUserProvider.getUser(), eventParams));
            this._notifyOdfRootPageChange(page);
        }
        return hasChanges;
    }

    private boolean _setOdfRootAttributes(Page page, String catalog, String firstLevel, String secondLevel, boolean areChildrenIndexable) {
        boolean hasChanges = false;
        if (page instanceof ModifiablePage) {
            ModifiablePage modifiablePage = (ModifiablePage)page;
            if (StringUtils.isNotEmpty((CharSequence)catalog)) {
                modifiablePage.setValue("odf-root-catalog", (Object)catalog);
            }
            if (StringUtils.isNotEmpty((CharSequence)firstLevel)) {
                modifiablePage.setValue("firstLevel", (Object)firstLevel);
            } else {
                modifiablePage.removeValue("firstLevel");
            }
            if (StringUtils.isNotEmpty((CharSequence)secondLevel)) {
                modifiablePage.setValue("secondLevel", (Object)secondLevel);
            } else {
                modifiablePage.removeValue("secondLevel");
            }
            modifiablePage.setValue("indexableChildren", (Object)areChildrenIndexable);
            if (modifiablePage.needsSave()) {
                modifiablePage.saveChanges();
                hasChanges = true;
            }
        }
        return hasChanges;
    }

    @Callable(rights={"ODF_Rights_SetRootPage"})
    public boolean removeOdfRootPage(String pageId) throws RepositoryException {
        JCRAmetysObject jcrPage;
        Property virtualProperty;
        boolean hasChanges = false;
        Page page = (Page)this._resolver.resolveById(pageId);
        if (page instanceof JCRAmetysObject && (virtualProperty = this._getVirtualProperty(jcrPage = (JCRAmetysObject)page)) != null) {
            Value[] oldValues = virtualProperty.getValues();
            Value[] newValues = (Value[])Arrays.stream(oldValues).filter(LambdaUtils.wrapPredicate(ODFRootClientSideElement::isVirtualPageFactoryValue).negate()).toArray(Value[]::new);
            this._setVirtualProperty(jcrPage, newValues);
            ModifiablePage modifiablePage = (ModifiablePage)page;
            modifiablePage.removeValue("firstLevel");
            modifiablePage.removeValue("secondLevel");
            modifiablePage.removeValue("odf-root-catalog");
            modifiablePage.removeValue("indexableChildren");
            if (jcrPage.needsSave()) {
                jcrPage.saveChanges();
                hasChanges = true;
            }
        }
        if (hasChanges) {
            HashMap<String, Page> eventParams = new HashMap<String, Page>();
            eventParams.put("page", page);
            this._observationManager.notify(new Event("odf.root.deleted", this._currentUserProvider.getUser(), eventParams));
            this._notifyOdfRootPageChange(page);
        }
        return hasChanges;
    }

    private void _notifyOdfRootPageChange(Page page) {
        this._odfPageHandler.clearRootCache();
        HashMap<String, Page> eventParams = new HashMap<String, Page>();
        eventParams.put("page", page);
        this._observationManager.notify(new Event("page.changed", this._currentUserProvider.getUser(), eventParams));
    }

    private Property _getVirtualProperty(JCRAmetysObject jcrPage) throws RepositoryException {
        Node node = jcrPage.getNode();
        if (node.hasProperty("ametys-internal:virtual")) {
            return node.getProperty("ametys-internal:virtual");
        }
        return null;
    }

    private void _setVirtualProperty(JCRAmetysObject jcrPage, Value[] values) throws RepositoryException {
        jcrPage.getNode().setProperty("ametys-internal:virtual", values);
    }

    private static boolean isVirtualPageFactoryValue(Value value) throws RepositoryException {
        return Strings.CS.equals(value.getString(), FirstLevelPageFactory.class.getName());
    }
}

