/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.inputdata;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfweb.repository.CoursePage;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.inputdata.InputData;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CourseInputData
extends AbstractLogEnabled
implements InputData,
Contextualizable,
Initializable,
Serviceable {
    protected Context _context;
    protected AmetysObjectResolver _ametysResolver;
    protected SiteManager _siteManager;
    protected OdfPageHandler _odfPageHandler;
    protected OdfReferenceTableHelper _odfRefTableHelper;
    protected ODFHelper _odfHelper;
    private boolean _isActive;

    public void service(ServiceManager manager) throws ServiceException {
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._ametysResolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._odfPageHandler = (OdfPageHandler)((Object)manager.lookup(OdfPageHandler.ROLE));
        this._odfRefTableHelper = (OdfReferenceTableHelper)manager.lookup(OdfReferenceTableHelper.ROLE);
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void initialize() throws Exception {
        this._isActive = (Boolean)Config.getInstance().getValue("odf.course.showReferences");
    }

    public boolean isCacheable(Site site, Page page) {
        return true;
    }

    public void toSAX(ContentHandler handler) throws SAXException, ProcessingException {
        if (this._isActive) {
            Course course;
            Set referencingPrograms;
            handler.startDocument();
            XMLUtils.startElement((ContentHandler)handler, (String)"programsSearchedByCourse");
            Request request = ContextHelper.getRequest((Context)this._context);
            String siteName = (String)request.getAttribute("site");
            String sitemapLanguage = (String)request.getAttribute("sitemapLanguage");
            Page page = (Page)request.getAttribute(Page.class.getName());
            if (page instanceof CoursePage && !(referencingPrograms = this._odfHelper.getParentPrograms((ProgramItem)(course = ((CoursePage)page).getCourse()))).isEmpty()) {
                Page rootPage = this._odfPageHandler.getOdfRootPage(siteName, sitemapLanguage);
                AttributesImpl atts = new AttributesImpl();
                if (rootPage != null) {
                    atts.addCDATAAttribute("root-page-path", rootPage.getPathInSitemap());
                }
                XMLUtils.startElement((ContentHandler)handler, (String)"programs", (Attributes)atts);
                for (Program program : referencingPrograms) {
                    try {
                        this.saxProgram(program, handler);
                    }
                    catch (IOException e) {
                        throw new ProcessingException("An error occurs SAXing a program : " + program.getId(), (Throwable)e);
                    }
                }
                XMLUtils.endElement((ContentHandler)handler, (String)"programs");
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"programsSearchedByCourse");
            handler.endDocument();
        }
    }

    public void saxProgram(Program program, ContentHandler contentHandler) throws SAXException, IOException {
        AttributesImpl atts = new AttributesImpl();
        List orgUnitIds = program.getOrgUnits();
        String degreeId = program.getDegree();
        String[] dgesipIds = program.getDGESIPCode();
        String[] siseids = program.getSiseCode();
        atts.addCDATAAttribute("name", program.getName());
        atts.addCDATAAttribute("title", program.getTitle());
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"program", (Attributes)atts);
        for (String domain : program.getDomain()) {
            atts.clear();
            atts.addCDATAAttribute("id", domain);
            atts.addCDATAAttribute("code", this._odfRefTableHelper.getItemCode(domain));
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"domain", (Attributes)atts);
        }
        for (String orgUnitId : orgUnitIds) {
            atts.clear();
            atts.addCDATAAttribute("id", orgUnitId);
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"orgUnit", (Attributes)atts);
        }
        if (StringUtils.isNotEmpty((CharSequence)degreeId)) {
            atts.clear();
            atts.addCDATAAttribute("id", degreeId);
            atts.addCDATAAttribute("code", this._odfRefTableHelper.getItemCode(degreeId));
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"degree", (Attributes)atts);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"degree");
        }
        if (dgesipIds != null) {
            for (String dgesipId : dgesipIds) {
                atts.clear();
                atts.addCDATAAttribute("id", dgesipId);
                atts.addCDATAAttribute("code", this._odfRefTableHelper.getItemCode(dgesipId));
                XMLUtils.startElement((ContentHandler)contentHandler, (String)"dgesip", (Attributes)atts);
                XMLUtils.endElement((ContentHandler)contentHandler, (String)"dgesip");
            }
        }
        if (siseids != null) {
            for (String siseId : siseids) {
                atts.clear();
                atts.addCDATAAttribute("code", siseId);
                atts.addCDATAAttribute("code", this._odfRefTableHelper.getItemCode(siseId));
                XMLUtils.startElement((ContentHandler)contentHandler, (String)"sise", (Attributes)atts);
                XMLUtils.endElement((ContentHandler)contentHandler, (String)"sise");
            }
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"program");
    }
}

