/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.observation;

import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.cache.CacheInvalidationPolicy;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class InvalidateCacheOnOrgunitChangedObserver
extends AbstractLogEnabled
implements Observer,
Serviceable {
    protected SiteManager _siteManager;
    protected OdfPageHandler _odfPageHandler;
    protected CacheInvalidationPolicy _cachePolicy;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._siteManager = (SiteManager)serviceManager.lookup(SiteManager.ROLE);
        this._odfPageHandler = (OdfPageHandler)((Object)serviceManager.lookup(OdfPageHandler.ROLE));
        this._cachePolicy = (CacheInvalidationPolicy)serviceManager.lookup(CacheInvalidationPolicy.ROLE);
    }

    public boolean supports(Event event) {
        return event.getArguments().get("content") instanceof OrgUnit && (event.getId().equals("content.validated") || event.getId().equals("content.deleting") || event.getId().equals("content.untag.live") || event.getId().equals("content.modified"));
    }

    public int getPriority() {
        return 4000;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        OrgUnit orgUnit = (OrgUnit)event.getArguments().get("content");
        for (Site site : this._siteManager.getSites()) {
            if (!this._odfPageHandler.hasOdfRootPage(site)) continue;
            try {
                this._cachePolicy.invalidateCacheOnContentModification(site, (Content)orgUnit);
            }
            catch (Exception e) {
                this.getLogger().error("Unable to invalidate cache for OrgUnit {}", (Object)orgUnit, (Object)e);
            }
        }
    }
}

