/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.observation;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.web.synchronization.AbstractSynchronizeObserver;
import org.apache.commons.collections.PredicateUtils;

public class SynchronizedContentTranslatedObserver
extends AbstractSynchronizeObserver {
    public boolean supports(Event event) {
        return event.getId().equals("odf.content.translated");
    }

    protected void _internalObserve(Event event, Session liveSession) throws RepositoryException {
        Content content = (Content)event.getArguments().get("content");
        if (!(content instanceof JCRAmetysObject)) {
            return;
        }
        Node node = ((JCRAmetysObject)content).getNode();
        String translationNodeName = "ametys:translations";
        try {
            Node clonedNode = liveSession.getNodeByIdentifier(node.getIdentifier());
            Node translationsNode = node.getNode(translationNodeName);
            Node liveTranslationsNode = null;
            liveTranslationsNode = clonedNode.hasNode(translationNodeName) ? clonedNode.getNode(translationNodeName) : clonedNode.addNode(translationNodeName, "ametys:compositeMetadata");
            this._synchronizeComponent.cloneNodeAndPreserveUUID(translationsNode, liveTranslationsNode, PredicateUtils.truePredicate(), PredicateUtils.falsePredicate());
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        if (liveSession.hasPendingChanges()) {
            liveSession.save();
        }
    }
}

