/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.restrictions.rules;

import java.util.Set;
import org.ametys.odf.orgunit.RootOrgUnitProvider;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfweb.restrictions.rules.OdfRestrictionRule;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.apache.commons.lang3.StringUtils;

public class OdfOrgunitRestrictionRule
implements OdfRestrictionRule {
    private final RootOrgUnitProvider _ouProvider;
    private final String _rootOrgUnitId;

    public OdfOrgunitRestrictionRule(RootOrgUnitProvider ouProvider, String orgUnitId) {
        this._ouProvider = ouProvider;
        this._rootOrgUnitId = orgUnitId;
        if (StringUtils.isEmpty((CharSequence)this._rootOrgUnitId)) {
            throw new IllegalArgumentException("At least one non-null rule is required.");
        }
    }

    @Override
    public Expression getExpression() {
        Set validOrgUnits = this._ouProvider.getChildOrgUnitIds(this._rootOrgUnitId, true);
        validOrgUnits.add(this._rootOrgUnitId);
        Expression[] orgUnitExprs = (Expression[])validOrgUnits.stream().map(ou -> new StringExpression("orgUnit", Expression.Operator.EQ, ou)).toArray(Expression[]::new);
        return new OrExpression(orgUnitExprs);
    }

    @Override
    public boolean contains(Program program) {
        Set validOrgUnits = this._ouProvider.getChildOrgUnitIds(this._rootOrgUnitId, true);
        validOrgUnits.add(this._rootOrgUnitId);
        return program.getOrgUnits().stream().filter(StringUtils::isNotEmpty).anyMatch(orgUnitId -> validOrgUnits.contains(orgUnitId));
    }

    @Override
    public boolean hasOrgunitRestrictions() {
        return true;
    }
}

