<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
   
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xalan="http://xml.apache.org/xalan">
    
    <xsl:import href="service:web://pages/services/search/search-default/results/hit-common.xsl"/>
    
    <!-- Overrides the one in /search/helpers/html/hits.xsl -->
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.CourseSaxer']" mode="class-attribute">
        <xsl:text/>hit page<xsl:text> </xsl:text>
        <xsl:call-template name="common-utils-class"/>
    </xsl:template>
    <!-- Overrides the one in /search/helpers/html/hits.xsl -->
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.CourseSaxer']" mode="others">
        <xsl:call-template name="hit-course-pages"/>
    </xsl:template>
    
    <!-- Overrides the one in /search/helpers/html/hits.xsl -->
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.CourseSaxer']" mode="title-link">
        <a>
            <xsl:attribute name="href"><xsl:call-template name="hit-href"/></xsl:attribute>
            <xsl:value-of select="title"/>
        </a>
    </xsl:template>
    
    <!-- Overrides the one in /search/helpers/html/hits.xsl -->
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.CourseSaxer']" mode="abstract">
        <xsl:call-template name="hit-excerpt"/>
    </xsl:template>
    
    <!-- Overrides the one in /search/helpers/html/hits.xsl -->
    <xsl:template match="hit[@saxer = 'org.ametys.plugins.odfweb.service.search.CourseSaxer']" mode="date">
        <xsl:call-template name="hit-lastvalidation"/>
    </xsl:template>
    
    <xsl:template name="hit-course-pages">
        <xsl:if test="coursePage">
            <xsl:variable name="unsorted-pages">
                <xsl:for-each select="coursePage">
                    <page href="{resolvedUri}">
                        <name><xsl:call-template name="hit-course-pages-title"/></name>
                    </page>
                </xsl:for-each>
            </xsl:variable>
            
            <ul>
	            <xsl:for-each select="xalan:nodeset($unsorted-pages)/page">
	                <xsl:sort select="name"/>
	                
	                <li>
		                <a href="{@href}"><xsl:value-of select="name"/></a>
		            </li>
	            </xsl:for-each>
	        </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="hit-course-pages-title">
        <xsl:for-each select="path/element">
            <xsl:value-of select="."/>
            <xsl:if test="position() != last()"><xsl:text> </xsl:text>&gt;<xsl:text> </xsl:text></xsl:if>
        </xsl:for-each>
    </xsl:template>
    
</xsl:stylesheet>

