/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.catalog;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.ui.Callable;
import org.ametys.odf.catalog.Catalog;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.Page;

/**
 * DAO for ODF catalog.
 * Override {@link Catalog} to handle web specificities.
 */
public class CatalogDAO extends org.ametys.odf.catalog.CatalogDAO
{
    private OdfPageHandler _odfPageHandler;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _odfPageHandler = (OdfPageHandler) smanager.lookup(OdfPageHandler.ROLE);
    }

    @Callable(rights = "ODF_Rights_Catalog_Handle")
    @Override
    public Map<String, Object> removeCatalog(String catalogId, boolean forceDeletion)
    {
        Catalog catalog = null;
        try
        {
            catalog = _resolver.resolveById(catalogId);
        }
        catch (UnknownAmetysObjectException e)
        {
            return Map.of("error", "unknown-catalog");
        }

        Page page = _odfPageHandler.getOdfRootPage(null, null, catalog.getName());
        
        if (page != null)
        {
            Map<String, Object> result = new HashMap<>();
            result.put("error", "error-with-message");
            result.put("message", new I18nizableText("plugin.odf-web", "PLUGINS_ODFWEB_CATALOG_DELETE_ERROR_ODFROOT", Collections.singletonList(page.getTitle())));
            return result;
        }
        
        return super.removeCatalog(catalogId, forceDeletion);
        
    }
}
