/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.observation;

import java.util.Map;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.contenttype.ContentAttributeDefinition;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.tree.OdfClassificationHandler;
import org.ametys.plugins.odfweb.repository.FirstLevelPageFactory;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.VirtualFactoryExpression;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageQueryHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ClearLevelCacheObserver
extends AbstractLogEnabled
implements Observer,
Serviceable {
    private ContentHelper _contentHelper;
    private OdfClassificationHandler _odfClassificationHandler;
    private AmetysObjectResolver _resolver;
    private OdfPageHandler _odfPageHandler;
    private ContentTypeExtensionPoint _cTypeEP;
    private OdfReferenceTableHelper _odfReferenceTableHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._contentHelper = (ContentHelper)manager.lookup(ContentHelper.ROLE);
        this._odfClassificationHandler = (OdfClassificationHandler)manager.lookup(OdfClassificationHandler.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._odfPageHandler = (OdfPageHandler)((Object)manager.lookup(OdfPageHandler.ROLE));
        this._cTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._odfReferenceTableHelper = (OdfReferenceTableHelper)manager.lookup(OdfReferenceTableHelper.ROLE);
    }

    public boolean supports(Event event) {
        String eventId = event.getId();
        Content content = (Content)event.getArguments().get("content");
        return !(!eventId.equals("content.deleting") && !eventId.equals("content.modified") && !eventId.equals("content.added") || content == null || !(content instanceof OrgUnit) && !this._contentHelper.isReferenceTable(content));
    }

    public int getPriority() {
        return 0;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Content content = (Content)event.getArguments().get("content");
        if (content instanceof OrgUnit) {
            this._odfClassificationHandler.clearLevelValues("orgUnit", content.getLanguage());
        } else {
            AmetysObjectIterable<Page> rootPages = this._getODFRootPages();
            if (rootPages.getSize() == 0L) {
                this.getLogger().debug("There is no ODF root page, nothing to invalidate");
                return;
            }
            if (this._odfReferenceTableHelper.isTableReferenceEntry(content)) {
                for (Page rootPage : rootPages) {
                    String level2Attribute;
                    String level1Attribute = this._odfPageHandler.getLevel1Metadata(rootPage);
                    if (this._isPartOfClassification(content, level1Attribute)) {
                        this._odfClassificationHandler.clearLevelValues(level1Attribute, null);
                    }
                    if (!this._isPartOfClassification(content, level2Attribute = this._odfPageHandler.getLevel2Metadata(rootPage))) continue;
                    this._odfClassificationHandler.clearLevelValues(level2Attribute, null);
                }
            }
        }
    }

    private boolean _isPartOfClassification(Content targetContent, String attributName) {
        ModelItem modelItem;
        ContentType programCType;
        if (StringUtils.isNotEmpty((CharSequence)attributName) && (programCType = (ContentType)this._cTypeEP.getExtension("org.ametys.plugins.odf.Content.program")).hasModelItem(attributName) && (modelItem = programCType.getModelItem(attributName)) instanceof ContentAttributeDefinition) {
            return ArrayUtils.contains((Object[])targetContent.getTypes(), (Object)((ContentAttributeDefinition)modelItem).getContentTypeId());
        }
        return false;
    }

    protected AmetysObjectIterable<Page> _getODFRootPages() {
        VirtualFactoryExpression expression = new VirtualFactoryExpression(FirstLevelPageFactory.class.getName());
        String query = PageQueryHelper.getPageXPathQuery(null, null, null, (Expression)expression, null);
        return this._resolver.query(query);
    }
}

