/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.content;

import java.util.Map;

import org.ametys.cms.content.CopyReport;
import org.ametys.cms.repository.Content;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.workflow.CreateContentByCopyFunction;

/**
 * Component used for copy content in a web and ODF context
 * See {@link org.ametys.web.content.CopyContentComponent} and {@link org.ametys.odf.content.CopyContentComponent}
 */
public class CopyContentComponent extends org.ametys.odf.content.CopyContentComponent
{
    @Override
    protected Map<String, Object> getInputsForCopy(Content content, String title, Map<String, Object> copyMap, String targetContentType, CopyReport copyReport)
    {
        Map<String, Object> inputs = super.getInputsForCopy(content, title, copyMap, targetContentType, copyReport);
        if (content instanceof WebContent)
        {
            inputs.put(CreateContentByCopyFunction.SITE_KEY, ((WebContent) content).getSiteName()); 
        }
        
        return inputs;
    }
}
