<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
							  xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:cms="http://ametys.org/cms/3.0" 
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="cms">

    <xsl:import href="course.xsl"/>

    <!-- Used in common.xsl -->
    <xsl:variable name="common-content-css-class-name">course view-cart</xsl:variable>     
    
    <xsl:template name="common-content-head"/>
    
    <xsl:template name="common-content-body-title">
        <xsl:param name="title" select="metadata/title"/>
        
        <h4 class="cart-item-title">
            <a href="{resolver:resolve('odf', @id)}"><xsl:value-of select="$title"/></a>
        </h4>
        <xsl:if test="metadata/courseType">
            <span class="cart-item-type">
                <xsl:value-of select="metadata/courseType/@title"/>
            </span>
        </xsl:if>
    </xsl:template>  
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-content-body-content">
        <!-- Abstract -->
        <xsl:call-template name="common-content-body-simpletext">
            <xsl:with-param name="css-class-name">cart-item-abstract</xsl:with-param>
            <xsl:with-param name="text" select="''" />
            <xsl:with-param name="defaultText" select="metadata/description/docbook:article" />
            <xsl:with-param name="maxDefaultTextSize" select="200" />
        </xsl:call-template>
    </xsl:template>       
	
</xsl:stylesheet>