/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.util;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * Parse CSV file to extract codes and their label.
 * Generates two files:
 * - AUTO_[filename].xml with codes and their i18n key
 * - AUTO_[filename]-i18n.xml with i18n key
 * Configure __CODENAME and __FILE_PATH before run
 */
public class ParseCSVFileAction
{
    // TODO Personnalize
    private static final String __CODENAME = "CODE_NSF";
    private static final String __I18N_KEY_PREFIX = "APPLICATION_ODF_" + __CODENAME + "_";
    private static final String __FILE_PATH = "Z:\\Technique\\Ametys\\ODF\\Codes\\code_cnis_nsf.csv";
    
    public static void main(String[] args) throws Exception
    {
        File csvFile = new File (__FILE_PATH);
        String fileName = csvFile.getName();
        
        String outputFileName = fileName.substring(0, fileName.lastIndexOf("."));
        
        PrintWriter xmlOutput = new PrintWriter(new FileWriter("AUTO_" + outputFileName + ".xml"));
        PrintWriter i18nOutput = new PrintWriter(new FileWriter("AUTO_" + outputFileName + "-i18n.xml"));
        
        xmlOutput.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        i18nOutput.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        
        xmlOutput.println("<items>");
        i18nOutput.println("<messages>");
        
        List<String> codes = new ArrayList<>();
        
        for (String line : FileUtils.readLines(csvFile, "ISO-8859-1"))
        {
            String[] part = line.split(";");
            if (part.length > 1)
            {
                String code = StringUtils.trimToEmpty(part[0]);
                
                // Supprimer les doublons
                if (!codes.contains(code))
                {
                    codes.add(code);
                    String label = StringUtils.trimToEmpty(part[1]);
                    String i18nKey = __I18N_KEY_PREFIX + code;
                    
                    xmlOutput.println("<item code=\"" + code + "\" i18n-key=\"" + i18nKey + "\" cdmValue=\"" + label + "\"/>");
                    i18nOutput.println("<message key=\"" + i18nKey + "\">" + label + "</message>");
                }
            }
        }
        
        i18nOutput.println("</messages>");
        xmlOutput.println("</items>");
        
        i18nOutput.close();
        xmlOutput.close();
    }
}
