/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.workflow;

import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.orgunit.OrgUnitFactory;
import org.ametys.runtime.i18n.I18nizableText;

import com.opensymphony.workflow.WorkflowException;

/**
 * OSWorkflow function for creating a {@link OrgUnit} content.
 */
public class CreateOrgUnitFunction extends AbstractCreateODFContentFunction
{
    /** Content name prefix for programs */
    public static final String CONTENT_NAME_PREFIX = "orgunit-";
    
    @Override
    protected String _getContentNamePrefix()
    {
        return CONTENT_NAME_PREFIX;
    }
    
    @Override
    protected String _getObjectType(Map transientVars, Map args)
    {
        return OrgUnitFactory.ORGUNIT_NODETYPE;
    }
    
    @Override
    protected void _populateAdditionalData(Map transientVars, ModifiableContent content) throws WorkflowException
    {
        super._populateAdditionalData(transientVars, content);
        
        // Set a unique CDM code if not exist
        String cdmCode = content.getValue(OrgUnit.CODE_UAI);
        if (StringUtils.isEmpty(cdmCode))
        {
            content.setValue(OrgUnit.CODE_UAI, _odfHelper.generateUniqueCode(OrgUnitFactory.ORGUNIT_CONTENT_TYPE));
        }
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf", "PLUGINS_ODF_CREATE_ORGUNIT_FUNCTION_LABEL");
    }
}
