/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.xslt;

import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import org.ametys.core.util.dom.AmetysAttribute;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.program.SubProgram;

/**
 * DOM layer on structure of {@link SubProgram}.
 */
public class SubProgramElement extends AbstractODFElement<SubProgram>
{
    /**
     * Constructor.
     * @param subProgram the underlying {@link SubProgram}.
     * @param odfHelper ODFHelper to resolve children easily
     */
    public SubProgramElement(SubProgram subProgram, ODFHelper odfHelper)
    {
        this(subProgram, -1, null, odfHelper);
    }
    
    /**
     * Constructor.
     * @param subProgram the underlying {@link SubProgram}.
     * @param depth Set to positive number to get child subprograms structure until given depth. Set negative number to get all child subprograms structure
     * @param odfHelper ODFHelper to resolve children easily
     */
    public SubProgramElement(SubProgram subProgram, int depth, ODFHelper odfHelper)
    {
        this(subProgram, depth, null, odfHelper);
    }
    
    /**
     * Constructor.
     * @param subProgram the underlying {@link SubProgram}.
     * @param depth Set to positive value to get children subprogram structure
     * @param parent Parent of the element. Can be null
     * @param odfHelper ODFHelper to resolve children easily
     */
    public SubProgramElement(SubProgram subProgram, int depth, AbstractODFElement<?> parent, ODFHelper odfHelper)
    {
        super(subProgram, depth, parent, odfHelper);
    }

    @Override
    public String getTagName()
    {
        return "subprogram";
    }
    
    @Override
    protected Map<String, AmetysAttribute> _lookupAttributes()
    {
        Map<String, AmetysAttribute> result = super._lookupAttributes();
        
        result.put("title", new AmetysAttribute("title", "title", null, _object.getTitle(), this));
        
        String ects = _object.getEcts();
        if (StringUtils.isNotEmpty(ects))
        {
            result.put("ects", new AmetysAttribute("ects", "ects", null, ects, this));
        }
        
        String parentPath = _object.getContextPath();
        if (parentPath != null)
        {
            result.put("path", new AmetysAttribute("path", "path", null, parentPath + "/" + _object.getName(), this));
        }
        
        return result;
    }
}
