/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.pagesubscription.page.notifier;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.User;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.activities.PageUpdatedActivityType;
import org.ametys.web.repository.page.Page;

/**
 * Notifier for {@link PageUpdatedActivityType}
 */
public class PageSubscriptionPageUpdatedNotifier extends AbstractPageSubscriptionNotifier
{
    @Override
    public boolean supports(ActivityType activityType)
    {
        return activityType instanceof PageUpdatedActivityType;
    }
    
    @Override
    protected String getSiteParameterId()
    {
        return "page-subscription-content-validation";
    }
    
    @Override
    protected I18nizableText _getMailSubject(Activity activity, Page page)
    {
        List<String> i18nparam = new ArrayList<>();
        i18nparam.add(page.getSite().getTitle()); // {0}
        i18nparam.add(page.getTitle()); // {1}

        return new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_UPDATE_PAGE_SUBJECT", i18nparam);
    }
    
    @Override
    protected String _getMailHtmlBody(Activity activity, Page page, User author) throws IOException
    {
        String pageUrl = _getAbsolutePageUrl(page);
        return StandardMailBodyHelper.newHTMLBody()
                .withLanguage(page.getSitemapName())
                .withTitle(new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_UPDATE_PAGE_BODY_TITLE", List.of(page.getTitle())))
                .addMessage(new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_UPDATE_PAGE_BODY", List.of(author.getFullName(), page.getTitle(), page.getSite().getTitle())))
                .addMessage(new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_PAGE_LINK", List.of(pageUrl)))
                .withLink(pageUrl, new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_PAGE_LINK_TITLE"))
                .build();
    }
}
