/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.observation;

import java.util.Map;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.observation.AsyncObserver;
import org.ametys.core.observation.Event;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.pagesubscription.type.SubscriptionType;
import org.ametys.plugins.pagesubscription.type.SubscriptionTypeExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class RemoveSubscriptionOnSubscriberDeletedObserver
extends AbstractLogEnabled
implements AsyncObserver,
Serviceable {
    protected SiteManager _siteManager;
    protected SubscriptionTypeExtensionPoint _subscriptionTypeEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._subscriptionTypeEP = (SubscriptionTypeExtensionPoint)((Object)manager.lookup(SubscriptionTypeExtensionPoint.ROLE));
    }

    public boolean supports(Event event) {
        String eventId = event.getId();
        return "user.deleted".equals(eventId) || "group.deleted".equals(eventId);
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        boolean isUserEvent = switch (event.getId()) {
            case "user.deleted" -> true;
            case "group.deleted" -> false;
            default -> throw new IllegalArgumentException("Unexpected event id: " + event.getId());
        };
        UserIdentity user = (UserIdentity)event.getArguments().get("user");
        GroupIdentity group = (GroupIdentity)event.getArguments().get("group");
        try (AmetysObjectIterable sites = this._siteManager.getSites();){
            for (Site site : sites) {
                for (String typeId : this._subscriptionTypeEP.getExtensionsIds()) {
                    SubscriptionType subscriptionType = (SubscriptionType)this._subscriptionTypeEP.getExtension(typeId);
                    if (isUserEvent) {
                        subscriptionType.unsubscribeAll(site, user);
                        continue;
                    }
                    subscriptionType.unsubscribeAll(site, group);
                }
            }
        }
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

