/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.tracking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.type.PageSubscriptionType;
import org.ametys.plugins.pagesubscription.type.SubscriptionTypeExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.webanalytics.matomo.tracking.AbstractMatomoEventTrackingProvider;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class PageSubscriptionMatomoTrackingProvider
extends AbstractMatomoEventTrackingProvider
implements Serviceable {
    protected SubscriptionTypeExtensionPoint _subscriptionTypeEP;
    protected GroupManager _groupManager;
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._subscriptionTypeEP = (SubscriptionTypeExtensionPoint)((Object)manager.lookup(SubscriptionTypeExtensionPoint.ROLE));
        this._groupManager = (GroupManager)manager.lookup(GroupManager.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    protected List<AbstractMatomoEventTrackingProvider.MatomoEvent> getEvents(Site site) {
        ArrayList<AbstractMatomoEventTrackingProvider.MatomoEvent> requests = new ArrayList<AbstractMatomoEventTrackingProvider.MatomoEvent>();
        for (Map.Entry<String, Set<UserIdentity>> entry : this._getSubscribers(site).entrySet()) {
            String pageId = entry.getKey();
            Page page = this._silentlyResolve(pageId);
            if (page == null) continue;
            requests.add(new AbstractMatomoEventTrackingProvider.MatomoEvent(page.getSitemapName() + "/" + page.getPathInSitemap(), (double)entry.getValue().size()));
        }
        return requests;
    }

    private Page _silentlyResolve(String pageId) {
        try {
            return (Page)this._resolver.resolveById(pageId);
        }
        catch (Exception e) {
            this.getLogger().warn("Cannot track subscription for the page with id '{}'. It does not seem to exist.", (Object)pageId, (Object)e);
            return null;
        }
    }

    private Map<String, Set<UserIdentity>> _getSubscribers(Site site) {
        PageSubscriptionType subscriptionType = (PageSubscriptionType)this._subscriptionTypeEP.getExtension("subscription.page");
        HashMap<String, Set<UserIdentity>> subscribers = new HashMap<String, Set<UserIdentity>>();
        for (Subscription subscription : subscriptionType.getSubscriptions(site, null, null, null)) {
            String pageId = subscriptionType.getTarget(subscription);
            Set users = subscribers.computeIfAbsent(pageId, __ -> new HashSet());
            subscription.getSubscriber().ifPresent(users::add);
            subscription.getSubscribersGroup().map(arg_0 -> ((GroupManager)this._groupManager).getGroup(arg_0)).filter(Objects::nonNull).map(Group::getUsers).ifPresent(users::addAll);
        }
        return subscribers;
    }
}

