<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2014 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:template match="/ActionResult">
        <html>
            <head/>
            
            <body id="default">
                <xsl:choose>
                    <xsl:when test="error">
                        <div class="submit-errors">
                            <h1><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_ERROR_TITLE" i18n:catalogue="plugin.page-subscription"/></h1>
                            <p><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_ERROR_DESCRIPTION" i18n:catalogue="plugin.page-subscription"/></p>
                            <ul>
                                <xsl:for-each select="error">
                                    <li><xsl:value-of select="."/></li>
                                </xsl:for-each>
                            </ul>
                            <noscript>
                                <p><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_ERROR_BACK_ALT" i18n:catalogue="plugin.page-subscription"/></p>
                            </noscript>
                            <script type="text/javascript">
                                document.write("&lt;p&gt;&lt;a href='javascript: history.back();'&gt;<i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_ERROR_BACK" i18n:catalogue="plugin.page-subscription"/>&lt;/a&gt;&lt;/p&gt;")
                            </script>
                        </div>
                    </xsl:when>
                    <xsl:otherwise>
                        <div class="submit-success">
                            <xsl:choose>
                                <xsl:when test="action = 'subscribe'">
                                    <h1><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_SUCCESS_SUBSCRIBE_TITLE" i18n:catalogue="plugin.page-subscription"/></h1>
                                    <p><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_SUBSCRIBE_OK" i18n:catalogue="plugin.page-subscription"/></p>
                                </xsl:when>
                                <xsl:when test="action = 'unsubscribe'">
                                    <h1><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_SUCCESS_UNSUBSCRIBE_TITLE" i18n:catalogue="plugin.page-subscription"/></h1>
                                    <p><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_UNSUBSCRIBE_OK" i18n:catalogue="plugin.page-subscription"/></p>
                                </xsl:when>
                            </xsl:choose>
                            
                            <noscript>
                                <p><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_SUCCESS_BACK_ALT" i18n:catalogue="plugin.page-subscription"/></p>
                            </noscript>
                            <script type="text/javascript">
                                document.write("&lt;p&gt;&lt;a href='javascript: history.back();'&gt;<i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_SUCCESS_BACK" i18n:catalogue="plugin.page-subscription"/>&lt;/a&gt;&lt;/p&gt;")
                            </script>
                        </div>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    
</xsl:stylesheet>