/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.proxiedcontent;

import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.Session;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;

import org.ametys.plugins.extrausermgt.authentication.cas.AmetysCas20ProxyReceivingTicketValidationFilter;
import org.ametys.plugins.site.proxy.BackOfficeRequestProxy;

/**
 * Add a request header with CAS proxy granting ticket
 */
public class ProxyGrantingTicketProxy implements BackOfficeRequestProxy
{
    public void prepareBackOfficeRequest(Request request, HttpUriRequest backOfficeRequest)
    {
        Session session = request.getSession(false);
        if (session != null)
        {
            String casProxyGrantingTicket = (String) session.getAttribute(AmetysCas20ProxyReceivingTicketValidationFilter.SESSION_ATTRIBUTE_PROXY_GRANTING_TICKET);
            if (casProxyGrantingTicket != null)
            {
                backOfficeRequest.addHeader(new BasicHeader("X-Ametys-FO-PGT", casProxyGrantingTicket));
            }
        }
    }
    
    public void handleBackOfficeResponse(Response response, HttpResponse backOfficeResponse)
    {
        // does nothing
    }
}
