/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.proxiedcontent;

import java.util.Map;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.extrausermgt.authentication.cas.CASCredentialProvider;

/**
 * Helper for the revamping service
 */
public class RevampingHelper extends AbstractLogEnabled implements Serviceable, Component
{
    /** Avalon Role */
    public static final String ROLE = RevampingHelper.class.getName();
    
    private static final String __PARAM_PROXY_TICKETS = "authentication.cas.requestProxyTickets"; 
    
    /** The DAO for user populations */
    protected UserPopulationDAO _userPopulationDAO;

    public void service(ServiceManager manager) throws ServiceException
    {
        _userPopulationDAO = (UserPopulationDAO) manager.lookup(UserPopulationDAO.ROLE);
    }
    
    /**
     * Check if the revamping through CAS is currently available or not
     * @return True if the revamping through CAS is available
     */
    @Callable
    public boolean isCasAvailable()
    {
        for (UserPopulation userPopulation : _userPopulationDAO.getEnabledUserPopulations(false))
        {
            for (CredentialProvider credentialProvider : userPopulation.getCredentialProviders())
            {
                if (credentialProvider instanceof CASCredentialProvider)
                {
                    Map<String, Object> parameterValues = credentialProvider.getParameterValues();
                    if (parameterValues.containsKey(__PARAM_PROXY_TICKETS) && (boolean) parameterValues.getOrDefault(__PARAM_PROXY_TICKETS, false))
                    {
                        return true;
                    }
                }
            }
        }
        
        return false;
    }

}
