/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.proxiedcontent;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Utility class
 */
public final class Utils
{
    private static Pattern _pattern = Pattern.compile("(https?://[^/]*).*");
    
    private Utils()
    {
        // utility class
    }

    /**
     * Normalize URL
     * @param url The url
     * @return The normalized URL
     */
    static String normalizeUrl(String url)
    {
        String checkedUrl = url;
        
        if (!"".equals(url) && !url.startsWith("https://") && !url.startsWith("http://"))
        {
            checkedUrl = "http://" + url;
        }
        
        if (checkedUrl != null && checkedUrl.endsWith("/"))
        {
            checkedUrl = checkedUrl.substring(0, checkedUrl.lastIndexOf("/"));
        }
        
        return checkedUrl;
    }
    
    /**
     * Get the remote host from the given url
     * @param url the url
     * @return the remote host or empty if url does not match
     */
    static String getRemoteHostFromUrl(String url)
    {
        String remoteHost = "";
        
        Matcher matcher = _pattern.matcher(url);
        
        if (matcher.matches())
        {
            remoteHost = matcher.group(1);
        }
        
        return remoteHost;
    }
}
