/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.proxiedcontent;

import java.util.HashMap;
import java.util.Map;
import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.extrausermgt.authentication.cas.CASCredentialProvider;
import org.ametys.plugins.proxiedcontent.Utils;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.jasig.cas.client.proxy.Cas20ProxyRetriever;
import org.jasig.cas.client.validation.Assertion;

public class GetUrlAction
extends ServiceableAction {
    protected UserPopulationDAO _userPopulationDAO;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(this.manager);
        this._userPopulationDAO = (UserPopulationDAO)smanager.lookup(UserPopulationDAO.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String url = request.getParameter("url");
        String server = request.getParameter("server");
        String isForm = request.getParameter("isForm");
        String baseUrl = Utils.normalizeUrl(source);
        String baseHost = Utils.getRemoteHostFromUrl(baseUrl);
        String completeUrl = "";
        if (url == null) {
            url = source;
        }
        if (server == null) {
            server = source;
        }
        url = Utils.normalizeUrl(url);
        server = Utils.normalizeUrl(server);
        String remoteHost = Utils.getRemoteHostFromUrl(url);
        if (baseHost.equals(remoteHost)) {
            if (isForm != null) {
                result.put("queryString", "?" + request.getQueryString());
            }
            completeUrl = url.substring(0, url.lastIndexOf("/") + 1);
            result.put("url", url);
            result.put("server", server);
            result.put("remote-server", remoteHost);
            result.put("complete-url", completeUrl);
            ZoneItem zoneItem = (ZoneItem)request.getAttribute(ZoneItem.class.getName());
            result.put("zoneitemid", zoneItem.getId());
            if (((Boolean)zoneItem.getServiceParameters().getValue("cas", false, (Object)false)).booleanValue()) {
                this._addCasProxyTicketInUrl(request, url, result);
            }
            return result;
        }
        this.getLogger().error("The specified page '" + url + "' is not on the same host than the base page, and therefore could not be proxified.");
        return null;
    }

    private void _addCasProxyTicketInUrl(Request request, String url, Map<String, String> result) {
        String cpId;
        CredentialProvider credentialProvider;
        String populationId;
        UserPopulation population;
        Assertion assertion;
        String proxyTicket = null;
        Session session = request.getSession(false);
        if (session != null && (assertion = (Assertion)session.getAttribute("_const_cas_assertion_")) != null) {
            proxyTicket = assertion.getPrincipal().getProxyTicketFor(url);
        }
        if ("true".equals(request.getHeader("X-Ametys-FO")) && request.getHeader("X-Ametys-FO-PGT") != null && (population = this._userPopulationDAO.getUserPopulation(populationId = request.getHeader("X-Ametys-FO-Population"))) != null && (credentialProvider = population.getCredentialProvider(cpId = request.getHeader("X-Ametys-FO-Credential-Provider"))) instanceof CASCredentialProvider) {
            String casUrl = (String)credentialProvider.getParameterValues().get("authentication.cas.serverUrl");
            String proxyGrantingTicket = request.getHeader("X-Ametys-FO-PGT");
            proxyTicket = new Cas20ProxyRetriever(casUrl, "UTF-8", null).getProxyTicketIdFor(proxyGrantingTicket, url);
        }
        if (proxyTicket != null) {
            StringBuilder urlWithTicket = new StringBuilder(url);
            urlWithTicket.append(!url.contains("?") ? "?" : "&").append("ticket=").append(URIUtils.encodeParameter((String)proxyTicket));
            result.put("url", urlWithTicket.toString());
        } else {
            this.getLogger().warn(String.format("The application was unable to retrieve a proxy ticket from CAS for target service '%s'", url));
        }
    }
}

