<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xhtml="http://www.w3.org/1999/xhtml"
    xmlns:encoder="org.ametys.core.util.URIUtils"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
	extension-element-prefixes="encoder ametys">
    
    <xsl:param name="remote-server"/>
    <xsl:param name="server"/>
    <xsl:param name="complete-url"/>
    <xsl:param name="keep-js">false</xsl:param>
    <xsl:param name="zoneitemid"/>
    
    <!-- Ignore the "base" url -->
    <xsl:template match="head/base|xhtml:head/xhtml:base"/>
    
    <!-- Ignore the css links -->
    <xsl:template match="link[@rel='stylesheet']|xhtml:link[@rel='stylesheet']"/>
    
    <xsl:template match="img[@src]|xhtml:img[@src]">
        <img>
            <xsl:copy-of select="@*[name()!='src']"/>
            <xsl:attribute name="src">
                <xsl:choose>
                    <xsl:when test="starts-with(@src,'http://')"><xsl:value-of select="@src"/></xsl:when>
                    <xsl:when test="starts-with(@src,'/')"><xsl:value-of select="$remote-server"/><xsl:value-of select="@src"/></xsl:when>
                    <xsl:when test="starts-with(@src,'../')"><xsl:value-of select="$complete-url"/><xsl:value-of select="@src"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="ametys:uriPrefix()"/>/plugins/proxied-content/proxy?url=<xsl:value-of select="encoder:encodeParameter(concat($complete-url, @src))"/>&amp;zoneitemid=<xsl:value-of select="encoder:encodeParameter($zoneitemid)"/></xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
        </img>
    </xsl:template>
    
    <!-- Strip the js unless keep-js is set to "yes". -->
    <xsl:template match="script|xhtml:script">
        <xsl:if test="$keep-js = 'true'">
            <xsl:if test="starts-with(@src,'/')"></xsl:if>
            <script>
                <xsl:copy-of select="@*[name()!='src']"/>
                <xsl:if test="@src">
                    <xsl:attribute name="src">
                        <xsl:choose>
                            <xsl:when test="starts-with(@src,'http://')"><xsl:value-of select="substring-after(@src,'http://')"/>
                            </xsl:when>
                            <xsl:when test="starts-with(@src,'https://')"><xsl:value-of select="substring-after(@src,'https://')"/>
                            </xsl:when>
                            <xsl:when test="starts-with(@src,'/')"><xsl:value-of select="$remote-server"/><xsl:value-of select="@src"/>
                            </xsl:when>
                            <xsl:when test="contains(@src,':')"><xsl:value-of select="@src"/></xsl:when>
                            <xsl:otherwise><xsl:value-of select="ametys:uriPrefix()"/>/plugins/proxied-content/proxy?url=<xsl:value-of select="encoder:encodeParameter(concat($complete-url, @src))"/>&amp;zoneitemid=<xsl:value-of select="encoder:encodeParameter($zoneitemid)"/></xsl:otherwise>
                        </xsl:choose>
                    </xsl:attribute>
                </xsl:if>
                <xsl:apply-templates/>
            </script>
        </xsl:if>
    </xsl:template>
    
    
    <xsl:template match="a[@href]|xhtml:a[@href]">
        <xsl:if test="starts-with(@href,'/')"></xsl:if>
        <a>
            <xsl:copy-of select="@*[name()!='href']"/>
            <xsl:attribute name="href">
                <xsl:choose>
                    <xsl:when test="starts-with(@href,'mailto:')"><xsl:value-of select="@href"/></xsl:when>
                    <xsl:when test="starts-with(@href,'javascript')"><xsl:value-of select="@href"/></xsl:when>
                    <xsl:when test="(starts-with(@href,'http://') or starts-with(@href,'https://')) and not(starts-with(@href, $remote-server))"><xsl:value-of select="@href"/></xsl:when>
                    <xsl:when test="starts-with(@href,'http://') or starts-with(@href,'https://')">?url=<xsl:value-of select="encoder:encodeParameter(string(@href))"/>&amp;server=<xsl:value-of select="$server"/></xsl:when>
                    <xsl:when test="starts-with(@href,'/')"><xsl:variable name="url"><xsl:value-of select="$remote-server"/><xsl:value-of select="@href"/></xsl:variable>?url=<xsl:value-of select="encoder:encodeParameter(string($url))"/>&amp;server=<xsl:value-of select="$server"/></xsl:when>
                    <xsl:when test="contains(@href,':')">?url=<xsl:value-of select="@href"/>&amp;server=<xsl:value-of select="$server"/></xsl:when>
                    <xsl:otherwise>?url=<xsl:value-of select="encoder:encodeParameter(concat($complete-url, @href))"/>&amp;server=<xsl:value-of select="$server"/></xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <xsl:apply-templates/>
        </a>
    </xsl:template>
    
    <xsl:template match="p|xhtml:p">
        <p>
            <xsl:copy-of select="@*[name()!='class' and name()!='style']"/>
            <xsl:apply-templates/>
        </p>
    </xsl:template>
    
    <xsl:template match="li|xhtml:li">
        <li>
            <xsl:copy-of select="@*[name()!='class' and name()!='style']"/>
            <xsl:apply-templates/>
        </li>
    </xsl:template>
    
    <xsl:template match="table|xhtml:table">
        <table>
            <xsl:apply-templates/>
        </table>
    </xsl:template>
    
    <xsl:template match="font|xhtml:font">
        <xsl:apply-templates/>
    </xsl:template>
    
    <xsl:template match="form|xhtml:form">
        <form method="get">
            <xsl:copy-of select="@*[name()!='method' and name()!='action']"/>
            <xsl:attribute name="action"></xsl:attribute>
                <xsl:choose>
                    <xsl:when test="starts-with(@action,'http://')">
                        <xsl:variable name="url"><xsl:value-of select="@action"/></xsl:variable>
                        <input type="hidden" name="isForm" value="true"/>
                        <input type="hidden" name="url">
                            <xsl:attribute name="value"><xsl:value-of select="$url"/></xsl:attribute>
                        </input>
                        <input type="hidden" name="server"><xsl:attribute name="value"><xsl:value-of select="$server"/></xsl:attribute></input>
                    </xsl:when>
                    <xsl:when test="starts-with(@action,'/')">
                        <xsl:variable name="url"><xsl:value-of select="$remote-server"/><xsl:value-of select="@action"/></xsl:variable>
                        <input type="hidden" name="isForm" value="true"/>
                        <input type="hidden" name="url">
                            <xsl:attribute name="value"><xsl:value-of select="$url"/></xsl:attribute>
                        </input>
                        <input type="hidden" name="server"><xsl:attribute name="value"><xsl:value-of select="$server"/></xsl:attribute></input>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:variable name="url"><xsl:value-of select="$complete-url"/>/<xsl:value-of select="@action"/></xsl:variable>
                        <input type="hidden" name="isForm" value="true"/>
                        <input type="hidden" name="url">
                            <xsl:attribute name="value"><xsl:value-of select="$url"/></xsl:attribute>
                        </input>
                        <input type="hidden" name="server"><xsl:attribute name="value"><xsl:value-of select="$server"/></xsl:attribute></input>
                    </xsl:otherwise>
                </xsl:choose>
            <xsl:apply-templates/>
        </form>
    </xsl:template>
    
    <xsl:template match="*">
        <xsl:element name="{local-name(.)}">
            <xsl:apply-templates select="@*[local-name()!='class' and local-name()!='style']"/>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>
     
    <xsl:template match="@*">
        <xsl:attribute name="{local-name(.)}">
            <xsl:value-of select="."/>
        </xsl:attribute>
    </xsl:template>
</xsl:stylesheet>
