<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    <xsl:import href="workspace:web://stylesheets/helper/html-hierarchy.xsl"/>
    
    <xsl:template match="/">
        <xsl:variable name="offset">
            <xsl:choose>
                <!-- 1 is "no offset" -->
                <xsl:when test="//h1">1</xsl:when>
                <xsl:when test="//h2">0</xsl:when>
                <xsl:when test="//h3">-1</xsl:when>
                <xsl:when test="//h4">-2</xsl:when>
                <xsl:when test="//h5">-3</xsl:when>
                <xsl:when test="//h6">-4</xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:apply-templates mode="move-hierarchy">
            <xsl:with-param name="level" select="number($offset)"/>
        </xsl:apply-templates>
    </xsl:template>
    
</xsl:stylesheet>
