<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:param name="baseUrl"/>
    <xsl:param name="url"/>
    
    <xsl:template match="/">
        <html>
            <body>
                <h1><i18n:text i18n:key="PLUGINS_PROXIED_CONTENT_REVAMPING_INVALID_PAGE_TITLE"/></h1>
                <p><i18n:text i18n:key="PLUGINS_PROXIED_CONTENT_REVAMPING_INVALID_PAGE_TEXT"/></p>
                <xsl:if test="normalize-space($url) != ''">
                <p>
                    <a href="{$url}"><i18n:text i18n:key="PLUGINS_PROXIED_CONTENT_REVAMPING_INVALID_PAGE_REDIRECT_EXTERNAL"/></a>
                </p>
                </xsl:if>
                <p>
                    <a href="{$baseUrl}" onclick="history.back(); return false;"><i18n:text i18n:key="PLUGINS_PROXIED_CONTENT_REVAMPING_INVALID_PAGE_REDIRECT_BASE"/></a>
                </p>
            </body>
        </html>
    </xsl:template>
    
</xsl:stylesheet>
