/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Provides a widget for checkbox input field.<br>
 * This widget is only enabled if there is an active cas population,
 * and cas proxy tickets are enabled
 */
Ext.define('Ametys.proxiedcontent.widget.revamping.cas', {
    extend: "Ametys.form.widget.Checkbox",
    
    constructor: function (config)
    {
        this.callParent(arguments);
        this.disable();

        Ametys.data.ServerComm.callMethod({
            role: "org.ametys.plugins.proxiedcontent.RevampingHelper",
            methodName: "isCasAvailable",
            parameters: [],
            callback: {
                scope: this,
                handler: this._isCasAvailableCb
            },
            errorMessage: {
                category: this.self.getName(),
                msg: "{{i18n PLUGINS_PROXIED_CONTENT_REVAMPING_CAS_ERROR}}"
            }
        });
    },

    /**
     * @private
     * Callback to know if cas is available
     * @param {Boolean} result true if cas is available
     */
    _isCasAvailableCb: function (result)
    {
        if (result == true)
        {
            this.enable();
        }
        else
        {
            this.setValue(false);
        }
    }
});
