/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.queriesdirectory;

import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.plugins.queriesdirectory.QueryContainer;
import org.ametys.plugins.queriesdirectory.QueryDAO;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryIntegrityViolationException;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;

public final class QueryAndContainerCommonMethods {
    private QueryAndContainerCommonMethods() {
    }

    public static boolean canMoveTo(AmetysObject newParent, SimpleAmetysObject queryOrQueryContainer, QueryDAO queryDAO) throws AmetysRepositoryException {
        return newParent instanceof QueryContainer && !queryOrQueryContainer.equals((Object)queryDAO.getQueriesRootNode());
    }

    public static void moveTo(AmetysObject newParent, boolean renameIfExist, SimpleAmetysObject queryOrQueryContainer) throws AmetysRepositoryException, RepositoryIntegrityViolationException {
        block6: {
            Node srcNode = queryOrQueryContainer.getNode();
            Node targetNode = ((QueryContainer)newParent).getNode();
            try {
                if (queryOrQueryContainer.getParent().equals((Object)newParent)) break block6;
                Object name = srcNode.getName();
                if (renameIfExist) {
                    int index = 1;
                    String origName = name;
                    while (targetNode.hasNode((String)name)) {
                        name = origName + "-" + index++;
                    }
                }
                String newPath = targetNode.getPath() + "/" + (String)name;
                Session session = srcNode.getSession();
                try {
                    session.move(srcNode.getPath(), newPath);
                }
                catch (ItemExistsException e) {
                    throw new AmetysRepositoryException("A query already exists for new path '" + newPath + "'", (Throwable)e);
                }
                session.save();
            }
            catch (RepositoryException e) {
                throw new AmetysRepositoryException("Unable to move query '" + String.valueOf(queryOrQueryContainer) + "' to node '" + newParent.getId() + "'", (Throwable)e);
            }
        }
    }

    public static void orderBefore(AmetysObject siblingNode, SimpleAmetysObject queryOrQueryContainer) throws AmetysRepositoryException {
        throw new UnsupportedOperationException("Query ordering is not supported");
    }
}

