/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.queriesdirectory;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.queriesdirectory.Query;
import org.ametys.plugins.queriesdirectory.QueryContainer;
import org.ametys.plugins.queriesdirectory.QueryHelper;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.MovableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;

public class QueryDAO
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = QueryDAO.class.getName();
    public static final String QUERY_HANDLE_RIGHT_ID = "QueriesDirectory_Rights_Admin";
    public static final String QUERY_CONTAINER_HANDLE_RIGHT_ID = "QueriesDirectory_Rights_Containers";
    public static final String ROOT_QUERY_CONTAINER_ID = "root";
    public static final String READ_ACCESS_PROPERTY = "canRead";
    public static final String WRITE_ACCESS_PROPERTY = "canWrite";
    public static final String RENAME_ACCESS_PROPERTY = "canRename";
    public static final String DELETE_ACCESS_PROPERTY = "canDelete";
    public static final String EDIT_RIGHTS_ACCESS_PROPERTY = "canAssignRights";
    private static final String __PLUGIN_NODE_NAME = "queriesdirectory";
    protected CurrentUserProvider _userProvider;
    protected ObservationManager _observationManager;
    private AmetysObjectResolver _resolver;
    private UserHelper _userHelper;
    private RightManager _rightManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._userProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._userHelper = (UserHelper)serviceManager.lookup(UserHelper.ROLE);
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
        this._observationManager = (ObservationManager)serviceManager.lookup(ObservationManager.ROLE);
    }

    public QueryContainer getQueriesRootNode() throws AmetysRepositoryException {
        try {
            return this._getOrCreateRootNode();
        }
        catch (AmetysRepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the queries root node", (Throwable)e);
        }
    }

    private QueryContainer _getOrCreateRootNode() throws AmetysRepositoryException {
        ModifiableTraversableAmetysObject pluginsNode = (ModifiableTraversableAmetysObject)this._resolver.resolveByPath("/ametys:plugins");
        ModifiableTraversableAmetysObject pluginNode = (ModifiableTraversableAmetysObject)QueryDAO._getOrCreateNode(pluginsNode, __PLUGIN_NODE_NAME, "ametys:unstructured");
        return (QueryContainer)QueryDAO._getOrCreateNode(pluginNode, "ametys:queries", "ametys:queries");
    }

    private static AmetysObject _getOrCreateNode(ModifiableTraversableAmetysObject parentNode, String nodeName, String nodeType) throws AmetysRepositoryException {
        AmetysObject definitionsNode;
        if (parentNode.hasChild(nodeName)) {
            definitionsNode = parentNode.getChild(nodeName);
        } else {
            definitionsNode = parentNode.createChild(nodeName, nodeType);
            parentNode.saveChanges();
        }
        return definitionsNode;
    }

    @Callable(rights={""})
    public Map<String, Object> getQueriesProperties(List<String> queryIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        LinkedList<Map<String, Object>> queries = new LinkedList<Map<String, Object>>();
        LinkedList<String> notAllowedQueries = new LinkedList<String>();
        HashSet<String> unknownQueries = new HashSet<String>();
        UserIdentity user = this._userProvider.getUser();
        for (String id : queryIds) {
            try {
                Query query = (Query)this._resolver.resolveById(id);
                if (this.canRead(user, query)) {
                    queries.add(this.getQueryProperties(query));
                    continue;
                }
                notAllowedQueries.add(query.getId());
            }
            catch (UnknownAmetysObjectException e) {
                unknownQueries.add(id);
            }
        }
        result.put("queries", queries);
        result.put("notAllowedQueries", notAllowedQueries);
        result.put("unknownQueries", unknownQueries);
        return result;
    }

    public Map<String, Object> getQueryProperties(Query query) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        ArrayList<String> fullPath = new ArrayList<String>();
        fullPath.add(query.getTitle());
        AmetysObject node = query.getParent();
        while (node instanceof QueryContainer && node.getParent() instanceof QueryContainer) {
            fullPath.add(0, node.getName());
            node = node.getParent();
        }
        infos.put("isQuery", true);
        infos.put("id", query.getId());
        infos.put("title", query.getTitle());
        infos.put("fullPath", String.join((CharSequence)" > ", fullPath));
        infos.put("type", query.getType());
        infos.put("description", query.getDescription());
        infos.put("documentation", query.getDocumentation());
        infos.put("author", this._userHelper.user2json(query.getAuthor()));
        infos.put("contributor", this._userHelper.user2json(query.getContributor()));
        infos.put("content", query.getContent());
        infos.put("lastModificationDate", DateUtils.zonedDateTimeToString((ZonedDateTime)query.getLastModificationDate()));
        infos.put("creationDate", DateUtils.zonedDateTimeToString((ZonedDateTime)query.getCreationDate()));
        UserIdentity currentUser = this._userProvider.getUser();
        infos.put(READ_ACCESS_PROPERTY, this.canRead(currentUser, query));
        infos.put(WRITE_ACCESS_PROPERTY, this.canWrite(currentUser, query));
        infos.put(DELETE_ACCESS_PROPERTY, this.canDelete(currentUser, query));
        infos.put(EDIT_RIGHTS_ACCESS_PROPERTY, this.canAssignRights(currentUser, query));
        return infos;
    }

    @Callable(rights={"QueriesDirectory_Rights_Containers", "QueriesDirectory_Rights_Admin"}, rightContext="right.assignment.context.queriesdirectoryaccess", paramIndex=0)
    public List<String> getIdsOfPath(String queryId) {
        AmetysObject queryOrQueryContainer = this._resolver.resolveById(queryId);
        QueryContainer queriesRootNode = this.getQueriesRootNode();
        if (!(queryOrQueryContainer instanceof Query) && !(queryOrQueryContainer instanceof QueryContainer)) {
            throw new IllegalArgumentException("The given id is not a query nor a query container");
        }
        ArrayList<String> pathElements = new ArrayList<String>();
        QueryContainer current = (QueryContainer)queryOrQueryContainer.getParent();
        while (!queriesRootNode.equals((Object)current)) {
            pathElements.add(0, current.getId());
            current = (QueryContainer)current.getParent();
        }
        return pathElements;
    }

    @Callable(rights={"QueriesDirectory_Rights_Tool", "CMS_Rights_Delegate_Rights", "Runtime_Rights_Rights_Handle"})
    public Map<String, Object> getRootProperties() {
        return this.getQueryContainerProperties(this.getQueriesRootNode());
    }

    @Callable(rights={""})
    public Map<String, Object> getQueryContainerProperties(String id) {
        QueryContainer container;
        UserIdentity user = this._userProvider.getUser();
        if (!this.canRead(user, container = this._getQueryContainer(id))) {
            throw new AccessDeniedException(String.valueOf(user) + " tried to access the properties of container " + id + " without sufficients rights");
        }
        return this.getQueryContainerProperties(container);
    }

    public Map<String, Object> getQueryContainerProperties(QueryContainer queryContainer) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("isQuery", false);
        infos.put("id", queryContainer.getId());
        infos.put("name", queryContainer.getName());
        infos.put("title", queryContainer.getName());
        infos.put("fullPath", this._getFullPath(queryContainer));
        UserIdentity currentUser = this._userProvider.getUser();
        infos.put(READ_ACCESS_PROPERTY, this.canRead(currentUser, queryContainer));
        infos.put(WRITE_ACCESS_PROPERTY, this.canWrite(currentUser, queryContainer));
        infos.put(RENAME_ACCESS_PROPERTY, this.canRename(currentUser, queryContainer));
        infos.put(DELETE_ACCESS_PROPERTY, this.canDelete(currentUser, queryContainer));
        infos.put(EDIT_RIGHTS_ACCESS_PROPERTY, this.canAssignRights(currentUser, queryContainer));
        return infos;
    }

    private String _getFullPath(QueryContainer queryContainer) {
        ArrayList<String> fullPath = new ArrayList<String>();
        fullPath.add(queryContainer.getName());
        AmetysObject node = queryContainer.getParent();
        while (node instanceof QueryContainer && node.getParent() instanceof QueryContainer) {
            fullPath.add(0, node.getName());
            node = node.getParent();
        }
        return String.join((CharSequence)" > ", fullPath);
    }

    @Callable(rights={"QueriesDirectory_Rights_Tool", "CMS_Rights_Delegate_Rights", "Runtime_Rights_Rights_Handle"})
    public List<String> filterQueries(String rootNode, String search, boolean ownerOnly, boolean requestType, boolean solrType, boolean scriptType, boolean formattingType) {
        ArrayList<String> matchingPaths = new ArrayList<String>();
        this._getMatchingQueries(this._getQueryContainer(rootNode), matchingPaths, StringUtils.stripAccents((String)search.toLowerCase()), ownerOnly, requestType, solrType, scriptType, formattingType);
        return matchingPaths;
    }

    private void _getMatchingQueries(QueryContainer queryContainer, List<String> matchingPaths, String search, boolean ownerOnly, boolean requestType, boolean solrType, boolean scriptType, boolean formattingType) {
        if (!(!StringUtils.isBlank((CharSequence)search) || ownerOnly || requestType || solrType || scriptType || formattingType)) {
            return;
        }
        String containerName = StringUtils.stripAccents((String)queryContainer.getName().toLowerCase());
        if (containerName.contains(search)) {
            matchingPaths.add(this._getQueryPath((AmetysObject)queryContainer));
        }
        if (!this.hasAnyReadableDescendant(this._userProvider.getUser(), queryContainer)) {
            return;
        }
        try (AmetysObjectIterable children = queryContainer.getChildren();){
            for (AmetysObject child : children) {
                if (child instanceof QueryContainer) {
                    QueryContainer childQueryContainer = (QueryContainer)child;
                    this._getMatchingQueries(childQueryContainer, matchingPaths, search, ownerOnly, requestType, solrType, scriptType, formattingType);
                    continue;
                }
                if (!(child instanceof Query)) continue;
                Query childQuery = (Query)child;
                this._getMatchingQuery(childQuery, matchingPaths, search, ownerOnly, requestType, solrType, scriptType, formattingType);
            }
        }
    }

    private void _getMatchingQuery(Query query, List<String> matchingPaths, String search, boolean ownerOnly, boolean requestType, boolean solrType, boolean scriptType, boolean formattingType) {
        String type = query.getType();
        if (!this.canRead(this._userProvider.getUser(), query) || formattingType && !"formatting".equals(type) || requestType && !Query.Type.SIMPLE.toString().equals(type) && !Query.Type.ADVANCED.toString().equals(type) || solrType && !"solr".equals(type) || scriptType && !Query.Type.SCRIPT.toString().equals(type) || ownerOnly && !query.getAuthor().equals((Object)this._userProvider.getUser())) {
            return;
        }
        if (this._contains(query, search)) {
            matchingPaths.add(this._getQueryPath((AmetysObject)query));
        }
    }

    private boolean _contains(Query query, String search) {
        if (StringUtils.stripAccents((String)query.getTitle().toLowerCase()).contains(search)) {
            return true;
        }
        if (StringUtils.stripAccents((String)query.getContent().toLowerCase()).contains(search)) {
            return true;
        }
        return StringUtils.stripAccents((String)query.getDescription().toLowerCase()).contains(search);
    }

    private String _getQueryPath(AmetysObject queryOrContainer) {
        if (queryOrContainer instanceof Query || queryOrContainer instanceof QueryContainer && queryOrContainer.getParent() instanceof QueryContainer) {
            return this._getQueryPath(queryOrContainer.getParent()) + "#" + queryOrContainer.getId();
        }
        return "#root";
    }

    @Callable(rights={""})
    public Map<String, Object> createQuery(String title, String desc, String documentation, String type, String content, String parentId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        QueryContainer queriesNode = this._getQueryContainer(parentId);
        if (!this.canWrite(this._userProvider.getUser(), queriesNode)) {
            results.put("message", "not-allowed");
            return results;
        }
        String name = NameHelper.filterName((String)title);
        Object uniqueName = name;
        int index = 2;
        while (queriesNode.hasChild((String)uniqueName)) {
            uniqueName = name + "-" + index++;
        }
        Query query = (Query)queriesNode.createChild((String)uniqueName, "ametys:query");
        query.setTitle(title);
        query.setDescription(desc);
        query.setDocumentation(documentation);
        query.setAuthor(this._userProvider.getUser());
        query.setContributor(this._userProvider.getUser());
        query.setType(type);
        query.setContent(content);
        query.setCreationDate(ZonedDateTime.now());
        query.setLastModificationDate(ZonedDateTime.now());
        queriesNode.saveChanges();
        results.put("id", query.getId());
        results.put("title", query.getTitle());
        results.put("content", query.getContent());
        return results;
    }

    @Callable(rights={""})
    public Map<String, Object> createQueryContainer(String parentId, String name) {
        QueryContainer parent = this._getQueryContainer(parentId);
        if (!this.canWrite(this._userProvider.getUser(), parent)) {
            return ImmutableMap.of((Object)"message", (Object)"not-allowed");
        }
        int index = 2;
        String legalName = Text.escapeIllegalJcrChars((String)name);
        Object realName = legalName;
        while (parent.hasChild((String)realName)) {
            realName = legalName + " (" + index + ")";
            ++index;
        }
        QueryContainer createdChild = (QueryContainer)parent.createChild((String)realName, "ametys:queries");
        parent.saveChanges();
        return this.getQueryContainerProperties(createdChild);
    }

    @Callable(rights={""})
    public Map<String, Object> updateQuery(String id, String title, String desc, String documentation) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Query query = (Query)this._resolver.resolveById(id);
        if (this.canWrite(this._userProvider.getUser(), query)) {
            query.setTitle(title);
            query.setDescription(desc);
            query.setDocumentation(documentation);
            query.setContributor(this._userProvider.getUser());
            query.setLastModificationDate(ZonedDateTime.now());
            query.saveChanges();
        } else {
            results.put("message", "not-allowed");
        }
        results.put("id", query.getId());
        results.put("title", query.getTitle());
        return results;
    }

    @Callable(rights={""})
    public Map<String, Object> renameQueryContainer(String id, String newName) {
        QueryContainer queryContainer = (QueryContainer)this._resolver.resolveById(id);
        UserIdentity currentUser = this._userProvider.getUser();
        if (this.canRename(currentUser, queryContainer)) {
            String legalName = Text.escapeIllegalJcrChars((String)newName);
            Node node = queryContainer.getNode();
            try {
                node.getSession().move(node.getPath(), node.getParent().getPath() + "/" + legalName);
                node.getSession().save();
                return this.getQueryContainerProperties((QueryContainer)this._resolver.resolveById(id));
            }
            catch (RepositoryException e) {
                this.getLogger().error("Unable to rename query container '{}'", (Object)id, (Object)e);
                return Map.of("message", "cannot-rename");
            }
        }
        return Map.of("message", "not-allowed");
    }

    @Callable(rights={""})
    public Map<String, Object> moveQuery(String id, String newParentId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Query query = (Query)this._resolver.resolveById(id);
        QueryContainer queryContainer = this._getQueryContainer(newParentId);
        if (this.canDelete(this._userProvider.getUser(), query) && this.canWrite(this._userProvider.getUser(), queryContainer)) {
            if (!this._move(query, newParentId)) {
                results.put("message", "cannot-move");
            }
        } else {
            results.put("message", "not-allowed");
        }
        results.put("id", query.getId());
        return results;
    }

    @Callable(rights={""})
    public Map<String, Object> moveQueryContainer(String id, String newParentId) {
        QueryContainer queryContainer = (QueryContainer)this._resolver.resolveById(id);
        QueryContainer parentQueryContainer = this._getQueryContainer(newParentId);
        UserIdentity currentUser = this._userProvider.getUser();
        if (this.canDelete(currentUser, queryContainer) && this.canWrite(currentUser, parentQueryContainer)) {
            if (this._move(queryContainer, newParentId)) {
                return this.getQueryContainerProperties((QueryContainer)this._resolver.resolveById(id));
            }
            return Map.of("id", id, "message", "cannot-move");
        }
        return Map.of("id", id, "message", "not-allowed");
    }

    private boolean _move(MovableAmetysObject obj, String newParentId) {
        QueryContainer newParent = this._getQueryContainer(newParentId);
        if (obj.canMoveTo((AmetysObject)newParent)) {
            try {
                obj.moveTo((AmetysObject)newParent, false);
                return true;
            }
            catch (AmetysRepositoryException e) {
                this.getLogger().error("Unable to move '{}' to query container '{}'", new Object[]{obj.getId(), newParentId, e});
            }
        }
        return false;
    }

    private QueryContainer _getQueryContainer(String id) {
        return ROOT_QUERY_CONTAINER_ID.equals(id) ? this.getQueriesRootNode() : (QueryContainer)this._resolver.resolveById(id);
    }

    @Callable(rights={""})
    public Map<String, Object> saveQuery(String id, String type, String content) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Query query = (Query)this._resolver.resolveById(id);
        UserIdentity user = this._userProvider.getUser();
        if (this.canWrite(user, query)) {
            query.setType(type);
            query.setContent(content);
            query.setContributor(user);
            query.setLastModificationDate(ZonedDateTime.now());
            query.saveChanges();
            results.put("id", query.getId());
            results.put("content", query.getContent());
            results.put("title", query.getTitle());
        } else {
            results.put("message", "not-allowed");
        }
        return results;
    }

    @Callable(rights={""})
    public Map<String, Object> deleteQuery(List<String> ids) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        ArrayList<String> deletedQueries = new ArrayList<String>();
        ArrayList<String> unknownQueries = new ArrayList<String>();
        ArrayList<String> notallowedQueries = new ArrayList<String>();
        for (String id : ids) {
            try {
                Query query = (Query)this._resolver.resolveById(id);
                if (this.canDelete(this._userProvider.getUser(), query)) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("queryId", query.getId());
                    query.remove();
                    query.saveChanges();
                    deletedQueries.add(id);
                    this._observationManager.notify(new Event("query.deleted", this._userProvider.getUser(), params));
                    continue;
                }
                notallowedQueries.add(query.getTitle());
            }
            catch (UnknownAmetysObjectException e) {
                unknownQueries.add(id);
                this.getLogger().error("Unable to delete query. The query of id '{}' doesn't exist", (Object)id, (Object)e);
            }
        }
        results.put("deletedQueries", deletedQueries);
        results.put("notallowedQueries", notallowedQueries);
        results.put("unknownQueries", unknownQueries);
        return results;
    }

    @Callable(rights={"*"})
    public boolean mustWarnBeforeDeletion(List<String> ids) {
        return ids.stream().anyMatch(LambdaUtils.wrapPredicate(this::_mustWarnBeforeDeletion));
    }

    private boolean _mustWarnBeforeDeletion(String id) {
        QueryContainer container = (QueryContainer)this._resolver.resolveById(id);
        AmetysObjectIterable<Query> allQueries = this.getChildQueriesForAdministrator(container, false, List.of());
        return this._containsNotOwnQueries(allQueries);
    }

    private boolean _containsNotOwnQueries(AmetysObjectIterable<Query> allQueries) {
        UserIdentity currentUser = this._userProvider.getUser();
        return allQueries.stream().map(Query::getAuthor).anyMatch((Predicate<UserIdentity>)Predicates.not(arg_0 -> ((UserIdentity)currentUser).equals(arg_0)));
    }

    @Callable(rights={""})
    public Map<String, Object> deleteQueryContainer(List<String> ids) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> deletedQueryContainers = new ArrayList<Map<String, Object>>();
        ArrayList<String> unknownQueryContainers = new ArrayList<String>();
        ArrayList<String> notallowedQueryContainers = new ArrayList<String>();
        for (String id : ids) {
            try {
                QueryContainer queryContainer = (QueryContainer)this._resolver.resolveById(id);
                if (this.canDelete(this._userProvider.getUser(), queryContainer)) {
                    Map<String, Object> props = this.getQueryContainerProperties(queryContainer);
                    queryContainer.remove();
                    queryContainer.saveChanges();
                    deletedQueryContainers.add(props);
                    continue;
                }
                notallowedQueryContainers.add(queryContainer.getName());
            }
            catch (UnknownAmetysObjectException e) {
                unknownQueryContainers.add(id);
                this.getLogger().error("Unable to delete query container. The query container of id '{}' doesn't exist", (Object)id, (Object)e);
            }
        }
        results.put("deletedQueryContainers", deletedQueryContainers);
        results.put("notallowedQueryContainers", notallowedQueryContainers);
        results.put("unknownQueryContainers", unknownQueryContainers);
        return results;
    }

    public AmetysObjectIterable<Query> getChildQueriesForAdministrator(QueryContainer parent, boolean onlyDirect, List<String> acceptedTypes) {
        return this._resolver.query(QueryHelper.getXPathForQueriesForAdministrator(parent, onlyDirect, acceptedTypes));
    }

    public Stream<Query> getChildQueriesInReadAccess(QueryContainer parent, boolean onlyDirect, UserIdentity user, List<String> acceptedTypes) {
        return this._resolver.query(QueryHelper.getXPathForQueries(parent, onlyDirect, acceptedTypes)).stream().filter(Query.class::isInstance).map(obj -> (Query)((Object)obj)).filter(query -> this.canRead(user, (Query)((Object)query)));
    }

    public boolean canRead(UserIdentity userIdentity, Query query) {
        return this._rightManager.hasReadAccess(userIdentity, (Object)query) || this.canWrite(userIdentity, query);
    }

    public boolean canRead(UserIdentity userIdentity, QueryContainer queryContainer) {
        return this._rightManager.hasReadAccess(userIdentity, (Object)queryContainer) || this.canWrite(userIdentity, queryContainer);
    }

    public Stream<Query> getChildQueriesInWriteAccess(QueryContainer parent, boolean onlyDirect, UserIdentity user, List<String> acceptedTypes) {
        return this._resolver.query(QueryHelper.getXPathForQueries(parent, onlyDirect, acceptedTypes)).stream().filter(Query.class::isInstance).map(obj -> (Query)((Object)obj)).filter(query -> this.canWrite(user, (Query)((Object)query)));
    }

    public boolean canWrite(UserIdentity userIdentity, Query query) {
        return this._rightManager.hasRight(userIdentity, QUERY_HANDLE_RIGHT_ID, (Object)query) == RightManager.RightResult.RIGHT_ALLOW;
    }

    public boolean canDelete(UserIdentity userIdentity, Query query) {
        return this.canWrite(userIdentity, query) && this.canWrite(userIdentity, (QueryContainer)query.getParent());
    }

    public boolean canRename(UserIdentity userIdentity, QueryContainer queryContainer) {
        return !this._isRoot(queryContainer) && this.canWrite(userIdentity, queryContainer) && this.canWrite(userIdentity, (QueryContainer)queryContainer.getParent());
    }

    public boolean canDelete(UserIdentity userIdentity, QueryContainer queryContainer) {
        return !this._isRoot(queryContainer) && this.canWrite(userIdentity, (QueryContainer)queryContainer.getParent()) && this.canWrite(userIdentity, queryContainer, true);
    }

    protected boolean _isRoot(QueryContainer queryContainer) {
        return this.getQueriesRootNode().equals((Object)queryContainer);
    }

    public Stream<Query> getChildQueriesInRightAccess(QueryContainer parent, boolean onlyDirect, UserIdentity user, List<String> acceptedTypes) {
        return this._resolver.query(QueryHelper.getXPathForQueries(parent, onlyDirect, acceptedTypes)).stream().filter(Query.class::isInstance).map(obj -> (Query)((Object)obj)).filter(query -> this.canAssignRights(user, (Query)((Object)query)));
    }

    public boolean canAssignRights(UserIdentity userIdentity, Query query) {
        return this.canWrite(userIdentity, query) || this._rightManager.hasRight(userIdentity, "Runtime_Rights_Rights_Handle", (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW;
    }

    public boolean canCreate(UserIdentity userIdentity, QueryContainer queryContainer) {
        return this.canWrite(userIdentity, queryContainer) || this._rightManager.hasRight(userIdentity, QUERY_CONTAINER_HANDLE_RIGHT_ID, (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW;
    }

    public boolean canWrite(UserIdentity userIdentity, QueryContainer queryContainer) {
        return this.canWrite(userIdentity, queryContainer, false);
    }

    public boolean canWrite(UserIdentity userIdentity, QueryContainer queryContainer, boolean recursively) {
        boolean hasRight;
        boolean bl = hasRight = this._rightManager.hasRight(userIdentity, QUERY_CONTAINER_HANDLE_RIGHT_ID, (Object)queryContainer) == RightManager.RightResult.RIGHT_ALLOW;
        if (!hasRight) {
            return false;
        }
        if (recursively) {
            try (AmetysObjectIterable children = queryContainer.getChildren();){
                for (AmetysObject child : children) {
                    if (child instanceof QueryContainer) {
                        hasRight = hasRight && this.canWrite(userIdentity, (QueryContainer)child, true);
                    } else if (child instanceof Query) {
                        boolean bl2 = hasRight = hasRight && this.canWrite(userIdentity, (Query)child);
                    }
                    if (hasRight) continue;
                    boolean bl3 = false;
                    return bl3;
                }
            }
        }
        return hasRight;
    }

    public boolean canAssignRights(UserIdentity userIdentity, QueryContainer queryContainer) {
        return this.canWrite(userIdentity, queryContainer) || this._rightManager.hasRight(userIdentity, "Runtime_Rights_Rights_Handle", (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW;
    }

    public AmetysObjectIterable<QueryContainer> getChildQueryContainers(QueryContainer parent) {
        return this._resolver.query(QueryHelper.getXPathForQueryContainers(parent));
    }

    public boolean hasAnyReadableDescendant(UserIdentity userIdentity, QueryContainer queryContainer) {
        try (AmetysObjectIterable children = queryContainer.getChildren();){
            for (AmetysObject child : children) {
                if (child instanceof QueryContainer) {
                    if (!this.canRead(userIdentity, (QueryContainer)child) && !this.hasAnyReadableDescendant(userIdentity, (QueryContainer)child)) continue;
                    boolean bl = true;
                    return bl;
                }
                if (!(child instanceof Query) || !this.canRead(userIdentity, (Query)child)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public Boolean hasAnyWritableDescendant(UserIdentity userIdentity, QueryContainer queryContainer) {
        boolean canWrite = false;
        try (AmetysObjectIterable children = queryContainer.getChildren();){
            for (AmetysObject child : children) {
                if (child instanceof QueryContainer) {
                    if (!this.canWrite(userIdentity, (QueryContainer)child) && !this.hasAnyWritableDescendant(userIdentity, (QueryContainer)child).booleanValue()) continue;
                    Boolean bl = true;
                    return bl;
                }
                if (!(child instanceof Query) || !this.canWrite(userIdentity, (Query)child)) continue;
                Boolean bl = true;
                return bl;
            }
        }
        return canWrite;
    }

    public boolean hasAnyAssignableDescendant(UserIdentity userIdentity, QueryContainer queryContainer) {
        try (AmetysObjectIterable children = queryContainer.getChildren();){
            for (AmetysObject child : children) {
                if (child instanceof QueryContainer) {
                    if (!this.canAssignRights(userIdentity, (QueryContainer)child) && !this.hasAnyAssignableDescendant(userIdentity, (QueryContainer)child)) continue;
                    boolean bl = true;
                    return bl;
                }
                if (!(child instanceof Query) || !this.canAssignRights(userIdentity, (Query)child)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

