/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.queriesdirectory.scripts;

import java.util.HashMap;
import java.util.Map;
import org.ametys.cms.scripts.CmsScriptHandler;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.queriesdirectory.Query;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class QueriesDirectoryScriptHandler
extends CmsScriptHandler {
    private AmetysObjectResolver _ametysObjectResover;
    private JSONUtils _jsonUtils;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._ametysObjectResover = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._jsonUtils = (JSONUtils)serviceManager.lookup(JSONUtils.ROLE);
    }

    @Callable(rights={"__READ_ACCESS", "QueriesDirectory_Rights_Admin"}, paramIndex=0, rightContext="right.assignment.context.queriesdirectoryaccess")
    public Map<String, Object> executeScript(String queryId, Map<String, Object> arguments) {
        Query query = (Query)this._ametysObjectResover.resolveById(queryId);
        String queryContentAsString = query.getContent();
        Map queryContentAsMap = this._jsonUtils.convertJsonToMap(queryContentAsString);
        Map toolParams = (Map)queryContentAsMap.get("toolParams");
        Map values = (Map)toolParams.get("values");
        String script = (String)values.get("script");
        HashMap<String, Object> modifiedArguments = new HashMap<String, Object>(arguments);
        modifiedArguments.put("script", script);
        return super.executeScript(modifiedArguments);
    }
}

