/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.queriesdirectory.Query;
import org.ametys.plugins.queriesdirectory.QueryDAO;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;

public class GetQueryParametersAction
extends ServiceableAction {
    private static final String _XSLT_BASE_LOCATION = "context://WEB-INF/stylesheets/export";
    private AmetysObjectResolver _resolver;
    private JSONUtils _jsonUtils;
    private CurrentUserProvider _currentUserProvide;
    private QueryDAO _queryDAO;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
        this._currentUserProvide = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._queryDAO = (QueryDAO)((Object)smanager.lookup(QueryDAO.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute("Runtime:InternalAllowedRequest", (Object)true);
        String queryId = request.getParameter("queryId");
        String xslt = parameters.getParameter("xslt", "");
        UserIdentity user = this._currentUserProvide.getUser();
        Query query = (Query)this._resolver.resolveById(queryId);
        if (!this._queryDAO.canRead(user, query)) {
            throw new AccessDeniedException("The user " + String.valueOf(user) + " is not allowed to access the query with id " + queryId);
        }
        String xsltFile = StringUtils.defaultString((String)this.getXsltLocation(resolver, xslt));
        Map content = this._jsonUtils.convertJsonToMap(query.getContent());
        Map params = (Map)content.get("exportParams");
        String versionLabel = parameters.getParameter("versionLabel");
        if (StringUtils.isNotBlank((CharSequence)versionLabel)) {
            params.put("versionLabel", versionLabel);
        }
        String pluginName = (String)content.get("exportXMLUrlPlugin");
        String exportUrl = (String)content.get("exportXMLUrl");
        result.put("pluginName", pluginName != null ? pluginName : "cms");
        result.put("exportUrl", exportUrl != null ? exportUrl : "search/export.xml");
        result.put("parameters", InternalEncoder.encode(this._jsonUtils.convertObjectToJson((Object)params)));
        result.put("xsltFile", xsltFile);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getXsltLocation(SourceResolver resolver, String xslt) throws IOException {
        Source xsltSource;
        block4: {
            String string;
            block5: {
                xsltSource = null;
                try {
                    String location;
                    if (!StringUtils.isNotBlank((CharSequence)xslt) || !(xsltSource = resolver.resolveURI(location = "context://WEB-INF/stylesheets/export/" + xslt)).exists()) break block4;
                    string = location;
                    if (xsltSource == null) break block5;
                }
                catch (Throwable throwable) {
                    if (xsltSource != null) {
                        resolver.release(xsltSource);
                    }
                    throw throwable;
                }
                resolver.release(xsltSource);
            }
            return string;
        }
        if (xsltSource != null) {
            resolver.release(xsltSource);
        }
        return null;
    }

    private static final class InternalEncoder {
        private static final char[] NEED_ENCODING = new char[]{'%', '&', '=', '?', ' ', '+'};

        private InternalEncoder() {
        }

        public static String encode(String str) {
            boolean changed = false;
            int escape = 37;
            int len = str.length();
            StringBuilder sb = new StringBuilder(len);
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                if (ArrayUtils.contains((char[])NEED_ENCODING, (char)ch)) {
                    sb.append('%');
                    sb.append(Integer.toHexString(ch));
                    changed = true;
                    continue;
                }
                sb.append(ch);
            }
            return changed ? sb.toString() : str;
        }
    }
}

