/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Queries directory context for profile assignments.
 */
Ext.define('Ametys.plugins.queriesdirectory.QueriesDirectoryRightAssignmentContext', {
    extend: 'Ametys.plugins.coreui.profiles.AbstractRightAssignmentContext',

    getComponent: function()
    {
        this._grid = Ext.create('Ametys.plugins.queriesdirectory.tree.QueriesTree', {
            rootVisible: true,
            stateful: true,         
            stateId: this.self.getName() + "$tree",     
            scrollable: true,
            profile: 'right_access',

            cls: 'queries-uitool',
            columns: [
                  {
                      xtype: 'treecolumn', 
                      header: "{{i18n PLUGINS_QUERIESDIRECTORY_UITOOL_QUERIES_COLUMN_TITLE}}", 
                      flex: 100, 
                      sortable: true, 
                      dataIndex: 'text', 
                      renderer: Ametys.plugins.queriesdirectory.tree.QueriesTree.renderTitle
                  },
                  {header: "{{i18n PLUGINS_QUERIESDIRECTORY_UITOOL_QUERIES_COLUMN_TYPE}}", width: 70, sortable: true, dataIndex: 'type', renderer: Ametys.plugins.queriesdirectory.tree.QueriesTree.renderType},
                  {header: "{{i18n PLUGINS_QUERIESDIRECTORY_UITOOL_QUERIES_COLUMN_DESCRIPTION}}", hidden: true, width: 180, sortable: true, dataIndex: 'description', renderer: Ametys.plugins.queriesdirectory.tree.QueriesTree.renderDescription},
                  {header: "{{i18n PLUGINS_QUERIESDIRECTORY_UITOOL_QUERIES_COLUMN_AUTHOR}}", hidden: false, width: 110, sortable: true, dataIndex: 'authorFullName'},
                  {header: "{{i18n PLUGINS_QUERIESDIRECTORY_UITOOL_QUERIES_COLUMN_LASTMODIFICATIONDATE}}", hidden: true, width: 110, sortable: true, dataIndex: 'lastModificationDate', renderer: Ext.util.Format.dateRenderer(Ext.Date.patterns.FriendlyDateTime)}
            ]
        });
        this._grid.on('selectionchange', this._onSelectionChanged, this);
        return this._grid;
    },
    
    initialize: function()
    {
        var me = this;
        this._grid.initRootNodeParameter(function(){
            if (me._queriesDirectoryPathToSelect)
            {
                me._grid.selectPath(me._grid.getRootNode().get('text') + ' > ' + me._queriesDirectoryPathToSelect, "text", " > ")
            }
            else
            {
                // Select root node
                me._grid.getSelectionModel().deselectAll();
                me._grid.getSelectionModel().select(0);
            }
        });
    },
    
    isSupported: function (message)
    {
        return message.getTargets(Ametys.message.MessageTarget.QUERY).length > 0 || message.getTargets(Ametys.message.MessageTarget.QUERY_CONTAINER).length > 0;
    },
    
    initContext: function (message)
    {
        var queryTarget = message.getTarget();
        if (queryTarget != null)
        {
            this._queriesDirectoryPathToSelect = queryTarget.getParameters().fullPath;
        }
    },
    
    /**
     * @private
     * Listener when the selection in the grid has changed
     * @param {Ext.selection.Model} model The selection model
     * @param {Ext.data.Model[]} selected The selected records
     */
    _onSelectionChanged: function(model, selected)
    {
        if (selected.length > 0)
        {
            var object = selected[0];
            var data = object.data;
            if (data.canAssignRights)
            {
                var hintTextContext;
                if (!data.root)
                {
                    hintTextContext = (data.isQuery ? "{{i18n PLUGINS_QUERIESDIRECTORY_QUERIESDIRECTORYACCESS_CONTEXT_HINT_QUERY}}" : "{{i18n PLUGINS_QUERIESDIRECTORY_QUERIESDIRECTORYACCESS_CONTEXT_HINT_QUERIESDIRECTORY}}") + " <b>" + selected[0].get('title') + "</b>";
                }
                else
                {
                    hintTextContext ="{{i18n PLUGINS_QUERIESDIRECTORY_QUERIESDIRECTORYACCESS_CONTEXT_HINT_ROOT}}";
                }
                
                this._changeObjectContext(object.get('id'), hintTextContext, false);
            }
            else
            {
                this._changeObjectContext(null);
            }
        }
        else
        {
            this._changeObjectContext(null);
        }
    }
});
