/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button that is able to check for conditions on query or query container
 */
Ext.define('Ametys.plugins.queriesdirectory.controllers.QueryController', {
    extend: 'Ametys.ribbon.element.ui.ButtonController',
    
    /**
     * @cfg {String} [enable-on-writeaccess-only="false"] If 'true' the button will be disabled as soon as the current user has no write access on query selection
     */
    /**
     * @cfg {String} description-no-writeaccess The description when the current user has no write access on query selection but #cfg-enable-on-writeaccess-only is true.
     */
    
    /**
     * @cfg {String} [enable-on-rightaccess-only="false"] If 'true' the button will be disabled as soon as the current user has no right access on query selection
     */
    /**
     * @cfg {String} description-no-rightaccess The description when the current user has no right access on query selection but #cfg-enable-on-rightaccess-only is true.
     */
    
    /**
     * @cfg {String} [enable-on-removeaccess-only="false"] If 'true' the button will be disabled as soon as the current user has no removeaccess access on query selection
     */
    /**
     * @cfg {String} description-no-removeaccess The description when the current user has no removeaccess access on query selection but #cfg-enable-on-removeaccess-only is true.
     */
    
    constructor: function (config)
    {
        this.callParent(arguments);
        
        Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onQueryModified, this);
    },
    
    additionalErrorDescriptionOnSelectionChanged: function(targets)
    {
        var enabledOnWriteAccessOnly = this.getInitialConfig("enable-on-writeaccess-only") == 'true';
        if (enabledOnWriteAccessOnly && targets.some(target => !target.getParameters().canWrite))
        {
            return this.getInitialConfig('description-no-writeaccess') || '';
        }
        
        var enabledOnRenameAccessOnly = this.getInitialConfig("enable-on-renameaccess-only") == 'true';
        if (enabledOnRenameAccessOnly && targets.some(target => !target.getParameters().canRename))
        {
            return this.getInitialConfig('description-no-renameaccess') || '';
        }
        
        var enabledOnRemoveAccessAccessOnly = this.getInitialConfig("enable-on-removeaccess-only") == 'true';
        if (enabledOnRemoveAccessAccessOnly && targets.some(target => !target.getParameters().canDelete))
        {
            return this.getInitialConfig('description-no-removeaccess') || '';
        }
        
        var enabledOnRightAccessOnly = this.getInitialConfig("enable-on-rightaccess-only") == 'true';
        if (enabledOnRightAccessOnly && targets.some(target => !target.getParameters().canAssignRights))
        {
            return this.getInitialConfig('description-no-rightaccess') || '';
        }
    },
    
    /**
     * Listener on modified message.
     * Update the state of the controller accordingly.
     * @param {Ametys.message.Message} message the message of type modified.
     * @private
     */
    _onQueryModified: function(message)
    {
        this.updateTargetsInCurrentSelectionTargets (message);
    }
    
});
