/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the simple query model.
 * @private
 */
Ext.define('Ametys.plugins.queriesdirectory.model.QueryFormatting', {
    extend: 'Ametys.plugins.queriesdirectory.model.AbstractQuery',
    
    statics: 
    {
        /**
         * @property {String} [QUERY_TYPE="simple"] The type of query
         */
        FORMATTING_TYPE: 'formatting'
    },
    
    /**
     * @inheritdoc
     */
    getTypeLabel: function ()
    {
        return "{{i18n PLUGINS_QUERIESDIRECTORY_UITOOL_QUERIES_TYPE_FORMATTING}}";
    },
    
    getTypeIconCls: function()
    {
        return 'ametysicon-paintbrush';  
    },
    
    /**
     * @inheritdoc
     */
    open : function()
    {
        // Do nothing
    },
    
    /**
     * @inheritdoc
     */
    execute : function()
    {
        var content = Ext.JSON.decode(this.content);

        var factoryId = content.toolId.split('$')[0];
        
        var currentTool = Ametys.tool.ToolsManager.getFocusedTool();
        if (factoryId != currentTool.getFactory().getId())
        {
            var msg = Ext.String.format("{{i18n PLUGINS_QUERIESDIRECTORY_UITOOL_APPLY_FORMATTING_ERROR_INCOMPATIBLETOOL}}", content.toolTitle ? '<b>' + content.toolTitle + '</b>' : '');
            Ametys.Msg.show({
                title: "{{i18n PLUGINS_QUERIESDIRECTORY_UITOOL_APPLY_FORMATTING_ERROR_TITLE}}",
                msg: msg,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            })
            return;
        }

        Ametys.tool.Tool.prototype.setParams.apply(currentTool, [Ext.apply(currentTool.getParams(), {
            formattingQueryId: this.queryId
        })]); // avoid tool refreshing
        
        if (currentTool.applyFormatting)
        {
            currentTool.applyFormatting(content.formatting);
        }
    }
});

Ametys.plugins.queriesdirectory.model.QueryFactory.registerQuery (Ametys.plugins.queriesdirectory.model.QueryFormatting.FORMATTING_TYPE, Ametys.plugins.queriesdirectory.model.QueryFormatting);
