/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the script query model.
 * @private
 */
Ext.define('Ametys.plugins.queriesdirectory.model.ScriptQuery', {
	extend: 'Ametys.plugins.queriesdirectory.model.AbstractQuery',
	
	statics:
	{
		/**
		 * @property {String} [QUERY_TYPE="script"] The type of query
		 */
		QUERY_TYPE: 'script'
	},
	
	/**
	 * @inheritdoc
	 */
	getTypeLabel: function ()
	{
		return "{{i18n PLUGINS_QUERIESDIRECTORY_UITOOL_QUERIES_TYPE_SCRIPT}}";
	},
    
    getTypeIconCls: function()
    {
        return 'ametysicon-development';  
    },
	
	/**
	 * @inheritdoc
	 */
	open : function()
	{
		var content = Ext.JSON.decode(this.content);

		var toolId = this._getToolId(content.toolId);
		var toolParams = content.toolParams || {};
		toolParams.expanded = true;
		toolParams.readOnly = this.readOnly;
        toolParams.queryId = this.queryId;
        toolParams.scriptToolId = this.queryId;
		
		Ametys.tool.ToolsManager.openTool(toolId, toolParams);
	},
	
	/**
	 * @inheritdoc
	 */
	execute : function()
	{
		var content = Ext.JSON.decode(this.content);

		var toolId = this._getToolId(content.toolId);
		var toolParams = content.toolParams || {};
		toolParams.readOnly = this.readOnly;
        toolParams.queryId = this.queryId;
        toolParams.startSearchAtOpening = true;
        toolParams.scriptToolId = this.queryId;

		Ametys.tool.ToolsManager.openTool(toolId, toolParams);
	},
    
    _getToolId: function(toolId)
    {
        if (Ametys.tool.ToolsManager.getFactory(toolId) != null)
        {
            return toolId;
        }
        else
        {
            return "uitool-script-executor";
        }
    }
});

Ametys.plugins.queriesdirectory.model.QueryFactory.registerQuery (Ametys.plugins.queriesdirectory.model.ScriptQuery.QUERY_TYPE, Ametys.plugins.queriesdirectory.model.ScriptQuery);