/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This tool does execute a queries directory script
 * @private
 */
Ext.define('Ametys.plugins.queriesdirectory.tool.ScriptExecutorTool', {
    extend: "Ametys.plugins.cms.search.ScriptTool",

    createPanel: function()
    {
        let p = this.callParent(arguments);
        this.searchPanel.hide();
        return p;
    },
    
    _callExecuteScript: function(script, parameters, callback) 
    {
        Ametys.data.ServerComm.callMethod({
            role: 'org.ametys.plugins.queriesdirectory.scripts.QueriesDirectoryScriptHandler',
            methodName: 'executeScript',
            parameters: [
                this.getParams().queryId,
                { 
                    parameters: parameters,
                    selection: this._convertedSelection || '',
                    model: "search-ui.default"
                }
            ],
            callback: {
                handler: callback,
                scope: this
            },
            waitMessage: {
                msg: "{{i18n plugin.cms:UITOOL_SEARCH_WAITING_MESSAGE}}",
                target: this.mainPanel
            },
            errorMessage: true
        });
    }
});
