/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Component to filter by query type
 * @private
 */
Ext.define('Ametys.plugins.queriesdirectory.tree.QueriesTree.QueryTypeFilter', {
    extend: 'Ext.container.Container',
    xtype: 'querytypefilter',
    
    /**
     * @cfg {Ametys.plugins.queriesdirectory.tree.QueriesTree} tree The parent tree
     */
    
    constructor: function(config)
    {
        var tree = config.tree;
        config.layout = {
            type: 'hbox',
            align: 'stretch'
        };
        config.defaultType = 'button';
        config.defaults = {
            enableToggle: true,
            scope: tree,
            cls: 'a-btn-light'
        };
        config.items = [{
            tooltip: "{{i18n PLUGINS_QUERIESDIRECTORY_TREE_FILTER_BY_TYPE_SIMPLE_ADVANCED}}",
            toggleHandler: this._toggleHandler,
            types: [Ametys.plugins.queriesdirectory.model.SimpleQuery.QUERY_TYPE, Ametys.plugins.queriesdirectory.model.AdvancedQuery.QUERY_TYPE],
            iconCls: 'a-btn-glyph ametysicon-magnifier41 size-16'
        }, {
            tooltip: "{{i18n PLUGINS_QUERIESDIRECTORY_TREE_FILTER_BY_TYPE_SOLR}}",
            toggleHandler: this._toggleHandler,
            types: [Ametys.plugins.queriesdirectory.model.SolrQuery.QUERY_TYPE],
            iconCls: 'a-btn-glyph ametysicon-solr size-16'
        }, {
            tooltip: "{{i18n PLUGINS_QUERIESDIRECTORY_TREE_FILTER_BY_TYPE_SCRIPT}}",
            toggleHandler: this._toggleHandler,
            types: [Ametys.plugins.queriesdirectory.model.ScriptQuery.QUERY_TYPE],
            iconCls: 'a-btn-glyph ametysicon-development size-16'
        }, {
            tooltip: "{{i18n PLUGINS_QUERIESDIRECTORY_TREE_FILTER_BY_TYPE_FORMATTING}}",
            toggleHandler: this._toggleHandler,
            types: [Ametys.plugins.queriesdirectory.model.QueryFormatting.FORMATTING_TYPE],
            iconCls: 'a-btn-glyph ametysicon-paintbrush size-16'
        }];
        
        this.callParent(arguments);
    },
    
    /**
     * Untoggle all buttons
     * @param {Boolean} [suppressEvent=false] True to stop events being fired when calling this method.
     */
    untoggleAll: function(supressEvent)
    {
        this.items.each(function(b) {
            b.toggle(false, supressEvent);
        });
    },
    
    getValues: function()
    {
        return {
            request: this.items.get(0).pressed,
            solr: this.items.get(1).pressed,
            script: this.items.get(2).pressed,
            formatting: this.items.get(3).pressed
        }
    },
    
    /**
     * @private
     * Function called when a button is pressed
     * @param {Ext.button.Button} btn The button.
     * @param {Boolean} state The next state of the Button, true means pressed.
     */
    _toggleHandler: function(btn, state)
    {
        var id = btn.id,
            allButtons = btn.up().items,
            otherButtons = allButtons.filterBy(function(item) {return item.id != id}),
            tree = this;
            
        if (state)
        {
            otherButtons.each(function(item) {
                item.toggle(false);
            });
        }
        tree._searchFilter()
    }
});
