/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

namespace QueriesDirectory
{
    export function query(queryId: string): org.ametys.plugins.repository.AmetysObjectIterable
	{
		const Arrays = Java.type('java.util.Arrays');
			
		const queryDAO = Ametys.serviceManager.lookup('org.ametys.plugins.queriesdirectory.QueryDAO');
		const jsonUtils = Ametys.serviceManager.lookup('org.ametys.core.util.JSONUtils')
		const contentSearcherFactory = Ametys.serviceManager.lookup('org.ametys.cms.search.content.ContentSearcherFactory')
		const getQueryFromJSONHelper = Ametys.serviceManager.lookup('org.ametys.cms.search.GetQueryFromJSONHelper')
				
		const queries = queryDAO.getQueriesProperties(Arrays.asList(queryId)).get("queries");
		if (queries.length == 0)
		{
			throw new Error(`No query found with id "${queryId}"`)
		}
		
	    const property = queries[0];
		const type = property.get("type");
		const content = jsonUtils.convertJsonToMap(property.get("content"));
	    switch (type)
	    {
	        case "solr":
				return Solr.contentQuery(content.get("toolParams").get("values").get("query"),
                                        content.get("toolParams").get("values").get("contentTypes"));
	        case "simple":
	        case "advanced":
				const model = getQueryFromJSONHelper.getSearchUIModel(content.get("exportParams"));
				
				const sortJson = jsonUtils.convertObjectToJson(content.get("toolParams").get("sort"))
				const sort = getQueryFromJSONHelper.getSort(sortJson, "");
				
				const values = content.get("exportParams").get("values")
				const facetValues = content.get("exportParams").get("facetValues")
				const contextualParameters = content.get("exportParams").get("contextualParameters") 
				
	            const results = contentSearcherFactory.create(model).withSearchMode(type)
	                                                             .withSort(sort)
	                                                             .withLimits(0, 50)
	                                                             .searchWithFacets(values, facetValues, contextualParameters);
				return results.getObjects();
	        case "script":
	          	throw new Error("Forbidden to execute a script. Only simple, advanced and solr search are allowed.");
			default:
	          	throw new Error("Unknow query type '" + type + "'. Unable to execute this query.");
		}

	}
}