/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.skincommons;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Stream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.ametys.core.cocoon.XMLResourceBundleFactory;
import org.ametys.core.util.path.PathUtils;
import org.ametys.plugins.skincommons.AsynchronousPathDeletion;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.ametys.web.cache.FOCommHelper;
import org.ametys.web.cache.pageelement.PageElementCache;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.skin.SkinsManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.i18n.BundleFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.InputSource;

public class SkinEditionHelper
extends AbstractLogEnabled
implements Component,
ThreadSafe,
Serviceable,
Contextualizable {
    public static final String ROLE = SkinEditionHelper.class.getName();
    private static final DateFormat _DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
    protected Context _cocoonContext;
    private SiteManager _siteManager;
    private PageElementCache _zoneItemCache;
    private PageElementCache _inputDataCache;
    private XMLResourceBundleFactory _i18nFactory;
    private SkinsManager _skinsManager;
    private FOCommHelper _foCommHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._zoneItemCache = (PageElementCache)smanager.lookup(PageElementCache.ROLE + "/zoneItem");
        this._inputDataCache = (PageElementCache)smanager.lookup(PageElementCache.ROLE + "/inputData");
        this._i18nFactory = (XMLResourceBundleFactory)smanager.lookup(BundleFactory.ROLE);
        this._skinsManager = (SkinsManager)smanager.lookup(SkinsManager.ROLE);
        this._foCommHelper = (FOCommHelper)smanager.lookup(FOCommHelper.ROLE);
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public Path createBackupFile(String skinName) throws IOException {
        Path backupDir = this.getBackupDirectory(skinName, new Date());
        PathUtils.moveDirectoryToDirectory((Path)this.getSkinDirectory(skinName), (Path)backupDir, (boolean)true);
        return backupDir;
    }

    public boolean deleteQuicklyDirectory(Path file) throws IOException {
        Path toDelete = file.getParent().resolve(String.valueOf(file.getFileName()) + "_todelete_" + RandomStringUtils.secure().next(10, false, true));
        try {
            Files.move(file, toDelete, new CopyOption[0]);
            Thread th = new Thread(new AsynchronousPathDeletion(toDelete));
            th.start();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void deleteOldBackup(String skinName, int keepMax) throws IOException {
        File rootBackupDir = this.getRootBackupDirectory(skinName);
        File[] allBackup = rootBackupDir.listFiles();
        Arrays.sort(allBackup, LastModifiedFileComparator.LASTMODIFIED_REVERSE);
        int index = 0;
        for (File f : allBackup) {
            if (index > keepMax - 1) {
                this.deleteQuicklyDirectory(f.toPath());
            }
            ++index;
        }
    }

    public void invalidateCaches(String skinName) throws Exception {
        Exception ex = null;
        for (Site site : this._siteManager.getSites()) {
            if (!skinName.equals(this._getSkinId(site))) continue;
            try {
                String siteName = site.getName();
                this._foCommHelper.invalidateFOCache(site);
                this._zoneItemCache.clear(null, siteName);
                this._inputDataCache.clear(null, siteName);
            }
            catch (Exception e) {
                this.getLogger().error("Error clearing the cache for site " + site.toString());
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    private String _getSkinId(Site site) {
        return site.getSkinId();
    }

    public void invalidateTempSkinCatalogues(String skinName) {
        this._invalidateSkinCatalogues(this.getTempDirectory(skinName), skinName, "ametys-home://skins/temp/" + skinName + "/i18n");
    }

    public void invalidateTempSkinCatalogue(String skinName, String lang) {
        this._invalidateSkinCatalogue(this.getTempDirectory(skinName), skinName, "ametys-home://skins/temp/" + skinName + "/i18n", lang);
    }

    public void invalidateSkinCatalogues(String skinName) {
        this._invalidateSkinCatalogues(this.getSkinDirectory(skinName), skinName, "skin-raw:" + skinName + "://i18n");
    }

    public void invalidateSkinCatalogue(String skinName, String lang) {
        this._invalidateSkinCatalogue(this.getSkinDirectory(skinName), skinName, "skin-raw:" + skinName + "://i18n", lang);
    }

    private void _invalidateSkinCatalogues(Path skinDir, String skinName, String catalogLocation) {
        Path i18nDir = skinDir.resolve("i18n");
        if (Files.exists(i18nDir, new LinkOption[0])) {
            try (Stream<Path> s = Files.list(i18nDir);){
                s.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(i18nFile -> {
                    String filename = i18nFile.getFileName().toString();
                    if (filename.equals("messages.xml")) {
                        this._invalidateSkinCatalogue(skinDir, skinName, catalogLocation, "");
                    } else if (filename.startsWith("messages_")) {
                        String lang = filename.substring("messages_".length(), "messages_".length() + 2);
                        this._invalidateSkinCatalogue(skinDir, skinName, catalogLocation, lang);
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot invalidate skin catalogs for skin " + skinName + " and location " + catalogLocation, e);
            }
        }
    }

    private void _invalidateSkinCatalogue(Path skinDir, String skinName, String catalogLocation, String lang) {
        try {
            Path f;
            String localName = lang;
            if (StringUtils.isNotEmpty((CharSequence)lang) && !Files.exists(f = skinDir.resolve("i18n/messages_" + lang + ".xml"), new LinkOption[0])) {
                localName = "";
            }
            this._i18nFactory.invalidateCatalogue(catalogLocation, "messages", localName);
        }
        catch (ComponentException e) {
            this.getLogger().warn("Unable to invalidate i18n catalog for skin " + skinName + " and location " + catalogLocation, (Throwable)e);
        }
    }

    public Path getTempDirectory(String skinName) {
        return RuntimeConfig.getInstance().getAmetysHome().toPath().resolve("skins/temp/" + skinName);
    }

    public Path getWorkDirectory(String skinName) {
        return RuntimeConfig.getInstance().getAmetysHome().toPath().resolve("skins/work/" + skinName);
    }

    public Path getBackupDirectory(String skinName, Date date) {
        String dateStr = _DATE_FORMAT.format(date);
        return RuntimeConfig.getInstance().getAmetysHome().toPath().resolve("skins/backup/" + skinName + "/" + dateStr);
    }

    public File getRootBackupDirectory(String skinName) {
        return FileUtils.getFile((File)RuntimeConfig.getInstance().getAmetysHome(), (String[])new String[]{"skins", "backup", skinName});
    }

    public String getTempDirectoryURI(String skinName) {
        return "ametys-home://skins/temp/" + skinName;
    }

    public String getWorkDirectoryURI(String skinName) {
        return "ametys-home://skins/work/" + skinName;
    }

    public String getBackupDirectoryURI(String skinName, Date date) {
        return "ametys-home://skins/backup/" + skinName + "/" + _DATE_FORMAT.format(date);
    }

    public String getRootBackupDirectoryURI(String skinName) {
        return "ametys-home://skins/backup/" + skinName;
    }

    public Path getSkinDirectory(String skinName) {
        return this._skinsManager.getSkin(skinName).getRawPath();
    }

    public String getTempModel(String skinName) {
        return this._getModel(this.getTempDirectory(skinName));
    }

    public String getWorkModel(String skinName) {
        return this._getModel(this.getWorkDirectory(skinName));
    }

    public String getSkinModel(String skinName) {
        return this._getModel(this.getSkinDirectory(skinName));
    }

    private String _getModel(Path skinDir) {
        String string;
        block10: {
            Path modelFile = skinDir.resolve("model.xml");
            if (!Files.exists(modelFile, new LinkOption[0])) {
                return null;
            }
            InputStream is = Files.newInputStream(modelFile, new OpenOption[0]);
            try {
                XPath xpath = XPathFactory.newInstance().newXPath();
                string = xpath.evaluate("model/@id", new InputSource(is));
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.getLogger().error("Can not determine the model of the skin", (Throwable)e);
                    return null;
                }
                catch (XPathExpressionException e) {
                    throw new IllegalStateException("The id of model is missing", e);
                }
            }
            is.close();
        }
        return string;
    }
}

