/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This tool extends {@link Ametys.file.AbstractFileExplorerTool} to display folders and files of a skin root directory.
 * @private
 */
Ext.define('Ametys.plugins.skineditor.SkinEditorTool', {
    extend: "Ametys.file.AbstractFileExplorerTool",
    
    /**
     * @property {String} _skinName The current skin name
     * @private
     */

    createTree: function ()
    {
        return Ext.create("Ametys.plugins.skineditor.SkinResourcesTree", {
            border: false
        });
    },

    setParams: function (params)
    {
        this._skinName = params.skinName;
        this._tree.setSkin(this._skinName);
       
        this.callParent(arguments);
    },

    openFile: function (record)
    {
    	Ametys.plugins.skineditor.resources.SkinResourcesActions.doOpenFile(record.get('name'), record.get('path'), record.get('skinName'));
    },
	
    /**
     * Get the current skin name
     * @return {String} The skin name
     */
    getSkinName: function ()
    {
        return this._skinName;
    }
});

Ext.define("Ametys.message.SkinEditorMessageTarget", {
	override: "Ametys.message.MessageTarget",
	
	statics: 
	{
		/**
		 * @member Ametys.message.MessageTarget
		 * @readonly
		 * @property {String} SKIN_RESOURCE The target type is a file resource of a skin. Parameters are:
		 * @property {String} SKIN_RESOURCE.name The file name
		 * @property {String} SKIN_RESOURCE.skinName The skin name
		 * @property {String} SKIN_RESOURCE.path The path into skin directory
		 */
		SKIN_RESOURCE: "skin-resource",
		
		/**
		 * @member Ametys.message.MessageTarget
		 * @readonly
		 * @property {String} SKIN_COLLECTION The target type is a folder resource of a skin. Parameters are:
		 * @property {String} SKIN_COLLECTION.name The file name
		 * @property {String} SKIN_COLLECTION.skinName The skin name
		 * @property {String} SKIN_COLLECTION.path The path into skin directory
		 */
		SKIN_COLLECTION: "skin-collection",
			
		/**
		 * @member Ametys.message.MessageTarget
		 * @readonly
		 * @property {String} SKIN_ROOT The target type is a root directory of a skin. Parameters are:
		 * @property {String} SKIN_ROOT.name The skin name
		 */
		SKIN_ROOT: "skin-root"
	}
});
