/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the model for nodes of a skin resources tree. See {@link Ametys.plugins.skineditor.SkinResourcesTree}
 * @private
 */
Ext.define('Ametys.plugins.skineditor.SkinResourcesTree.SkinResourcesNode', { 
	extend: 'Ametys.file.AbstractFileExplorerTree.FileNode',

	fields: [
		{name: 'skinName'},
		{
			name: 'iconCls',
            depends: ['type', 'name'],
			calculate: function (data)
			{
				if (data.type == 'root')
				{
					return "a-tree-glyph ametysicon-painter14";
				}
				else if (data.type == 'collection')
				{
					return "a-tree-glyph ametysicon-folder249";
				}
				else
				{
					return "a-tree-glyph " + Ametys.file.AbstractFileExplorerTree.getFileIconGlyph(data.name);
				}
			}
		}
	]
});