/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.clientsidelement;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.cms.languages.Language;
import org.ametys.cms.languages.LanguagesManager;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.SimpleMenu;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.util.I18nUtils;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class SkinLanguageMenu
extends SimpleMenu {
    private LanguagesManager _languageManager;
    private boolean _languagesInitialized;
    private I18nUtils _i18nUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._languageManager = (LanguagesManager)smanager.lookup(LanguagesManager.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
    }

    protected void _getGalleryItems(Map<String, Object> parameters, Map<String, Object> contextualParameters) {
        try {
            this._lazyInitializeLanguageGallery();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to lookup client side element local components", e);
        }
        if (this._galleryItems.size() > 0) {
            parameters.put("gallery-item", new LinkedHashMap());
            for (SimpleMenu.GalleryItem galleryItem : this._galleryItems) {
                Map galleryItems = (Map)parameters.get("gallery-item");
                galleryItems.put("gallery-groups", new ArrayList());
                for (SimpleMenu.GalleryGroup galleryGp : galleryItem.getGroups()) {
                    List galleryGroups = (List)galleryItems.get("gallery-groups");
                    LinkedHashMap<String, Object> groupParams = new LinkedHashMap<String, Object>();
                    I18nizableText label = galleryGp.getLabel();
                    groupParams.put("label", label);
                    ArrayList<String> gpItems = new ArrayList<String>();
                    for (ClientSideElement element : galleryGp.getItems()) {
                        gpItems.add(element.getId());
                    }
                    if (gpItems.size() <= 0) continue;
                    groupParams.put("items", gpItems);
                    galleryGroups.add(groupParams);
                }
            }
        }
    }

    private synchronized void _lazyInitializeLanguageGallery() throws ConfigurationException {
        if (!this._languagesInitialized) {
            Map availableLanguages = this._languageManager.getAvailableLanguages();
            if (availableLanguages.size() > 0) {
                SimpleMenu.GalleryItem galleryItem = new SimpleMenu.GalleryItem((SimpleMenu)this);
                SimpleMenu.GalleryGroup galleryGroup = new SimpleMenu.GalleryGroup((SimpleMenu)this, new I18nizableText("plugin." + this._pluginName, "RIBBON_TABS_TAB_SKINFACTORY_GROUP_LANG_LABEL"));
                galleryItem.addGroup(galleryGroup);
                for (String id : availableLanguages.keySet()) {
                    Language language = (Language)availableLanguages.get(id);
                    String itemId = this.getId() + "-" + id;
                    Configuration conf = this._getLanguageConfiguration(itemId, language);
                    this._getGalleryItemManager().addComponent(this._pluginName, null, itemId, StaticClientSideElement.class, conf);
                    galleryGroup.addItem(new SimpleMenu.UnresolvedItem((SimpleMenu)this, itemId, true));
                }
                this._galleryItems.add(galleryItem);
            }
            if (this._galleryItems.size() > 0) {
                try {
                    this._getGalleryItemManager().initialize();
                }
                catch (Exception e) {
                    throw new ConfigurationException("Unable to lookup parameter local components", (Throwable)e);
                }
            }
        }
        this._languagesInitialized = true;
    }

    protected Configuration _getLanguageConfiguration(String id, Language language) {
        DefaultConfiguration conf = new DefaultConfiguration("extension");
        conf.setAttribute("id", id);
        DefaultConfiguration classConf = new DefaultConfiguration("class");
        classConf.setAttribute("name", "Ametys.ribbon.element.ui.ButtonController");
        DefaultConfiguration labelConf = new DefaultConfiguration("label");
        labelConf.setValue(this._i18nUtils.translate((I18nizable)language.getLabel()));
        classConf.addChild((Configuration)labelConf);
        DefaultConfiguration iconSmallConf = new DefaultConfiguration("icon-small");
        iconSmallConf.setValue(language.getSmallIcon());
        classConf.addChild((Configuration)iconSmallConf);
        DefaultConfiguration iconMediumConf = new DefaultConfiguration("icon-medium");
        iconMediumConf.setValue(language.getMediumIcon());
        classConf.addChild((Configuration)iconMediumConf);
        DefaultConfiguration iconLargeConf = new DefaultConfiguration("icon-large");
        iconLargeConf.setValue(language.getLargeIcon());
        classConf.addChild((Configuration)iconLargeConf);
        DefaultConfiguration langConf = new DefaultConfiguration("lang");
        langConf.setValue(language.getCode());
        classConf.addChild((Configuration)langConf);
        Map commonConfig = (Map)this._script.getParameters().get("items-config");
        for (String tagName : commonConfig.keySet()) {
            DefaultConfiguration c = new DefaultConfiguration(tagName);
            c.setValue(String.valueOf(commonConfig.get(tagName)));
            classConf.addChild((Configuration)c);
        }
        conf.addChild((Configuration)classConf);
        return conf;
    }
}

