/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.clientsidelement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.SimpleMenu;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.util.I18nUtils;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.web.skin.SkinModel;
import org.ametys.web.skin.SkinModelsManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;

public class ThemeColorsMenu
extends SimpleMenu {
    private SkinModelsManager _modelsManager;
    private I18nUtils _i18nUtils;
    private boolean _themeColorsInitialized;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._modelsManager = (SkinModelsManager)smanager.lookup(SkinModelsManager.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        Map rights = this.getRights(contextParameters);
        if (!ignoreRights && !this.hasRight(rights)) {
            return Collections.EMPTY_LIST;
        }
        try {
            Set models = this._modelsManager.getModels();
            if (models.size() > 0) {
                this._lazyInitializeThemeColorsMenu(contextParameters);
                return super.getScripts(ignoreRights, contextParameters);
            }
            return Collections.EMPTY_LIST;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to lookup client side element local components", e);
        }
    }

    private synchronized void _lazyInitializeThemeColorsMenu(Map<String, Object> contextualParameters) throws ConfigurationException, ProcessingException {
        if (!this._themeColorsInitialized) {
            Set models = this._modelsManager.getModels();
            if (models.size() > 0) {
                for (String modelName : models) {
                    SkinModel model = this._modelsManager.getModel(modelName);
                    Map themes = model.getThemes();
                    if (themes.size() <= 0) continue;
                    for (SkinModel.Theme theme : themes.values()) {
                        String itemId = this.getId() + "-" + modelName + "-" + theme.getId();
                        Configuration conf = this._getThemeColorsConfiguration(itemId, theme, modelName, contextualParameters);
                        this._menuItemManager.addComponent(this._pluginName, null, itemId, StaticClientSideElement.class, conf);
                        this._unresolvedMenuItems.add(new SimpleMenu.UnresolvedItem((SimpleMenu)this, itemId, true));
                    }
                }
            }
            this._themeColorsInitialized = true;
        }
    }

    protected Configuration _getThemeColorsConfiguration(String id, SkinModel.Theme theme, String modelName, Map<String, Object> contextualParameters) {
        DefaultConfiguration conf = new DefaultConfiguration("extension");
        conf.setAttribute("id", id);
        DefaultConfiguration classConf = new DefaultConfiguration("class");
        classConf.setAttribute("name", "Ametys.plugins.skinfactory.ribbon.menu.ThemeColorsMenuItem");
        DefaultConfiguration labelConf = new DefaultConfiguration("label");
        labelConf.setValue(this._i18nUtils.translate((I18nizable)theme.getLabel()));
        classConf.addChild((Configuration)labelConf);
        List colors = theme.getColors();
        DefaultConfiguration colorSizeConf = new DefaultConfiguration("color-size");
        colorSizeConf.setValue(Integer.toString(colors.size()));
        classConf.addChild((Configuration)colorSizeConf);
        int j = 0;
        for (String color : colors) {
            DefaultConfiguration colorConf = new DefaultConfiguration("color-" + j);
            colorConf.setValue(color);
            classConf.addChild((Configuration)colorConf);
            ++j;
        }
        DefaultConfiguration modelNameConf = new DefaultConfiguration("modelName");
        modelNameConf.setValue(modelName);
        classConf.addChild((Configuration)modelNameConf);
        DefaultConfiguration themeConf = new DefaultConfiguration("theme");
        themeConf.setValue(theme.getId());
        classConf.addChild((Configuration)themeConf);
        Map commonConfig = (Map)this._script.getParameters().get("items-config");
        for (String tagName : commonConfig.keySet()) {
            DefaultConfiguration c = new DefaultConfiguration(tagName);
            c.setValue(String.valueOf(commonConfig.get(tagName)));
            classConf.addChild((Configuration)c);
        }
        conf.addChild((Configuration)classConf);
        Map rights = this.getRights(contextualParameters);
        ArrayList<DefaultConfiguration> rightsList = new ArrayList<DefaultConfiguration>();
        for (Map.Entry entry : rights.entrySet()) {
            DefaultConfiguration rightConf = new DefaultConfiguration("right");
            rightConf.setValue((String)entry.getKey());
            if (entry.getValue() != null) {
                rightConf.setAttribute("context-prefix", (String)entry.getValue());
            }
            rightsList.add(rightConf);
        }
        if (rightsList.size() == 1) {
            conf.addChild((Configuration)rightsList.get(0));
        } else if (rightsList.size() > 1) {
            DefaultConfiguration rightsConf = new DefaultConfiguration("rights");
            for (DefaultConfiguration rightConf : rightsList) {
                rightsConf.addChild((Configuration)rightConf);
            }
            conf.addChild((Configuration)rightsConf);
        }
        return conf;
    }
}

