/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.filefilter;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Predicate;

public final class FileFilter {
    private FileFilter() {
    }

    public static Predicate<Path> getSkinDirectoryFilter() {
        return path -> Files.isDirectory(path, new LinkOption[0]) && !path.getFileName().toString().equals("CVS") && !path.getFileName().toString().equals(".svn");
    }

    public static Predicate<Path> getSkinFileFilter() {
        return path -> !path.getFileName().toString().equals("CVS") && !path.getFileName().toString().equals(".svn");
    }

    public static final Predicate<Path> getModelFilter(Path modelDir) {
        return f -> !f.getFileName().toString().equals("CVS") && !f.getFileName().toString().equals(".svn") && (!f.getParent().equals(modelDir) || !f.getFileName().toString().equals("model"));
    }

    public static final Predicate<Path> getModelVariantFilter(String variantName, Path variantDir) {
        return f -> !f.getFileName().toString().equals("CVS") && !f.getFileName().toString().equals(".svn") && (!f.getParent().equals(variantDir) || !f.getFileName().toString().equals(variantName + ".xml") && !f.getFileName().toString().equals(variantName + ".png"));
    }
}

