/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.generators;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.ametys.core.util.IgnoreRootHandler;
import org.ametys.plugins.skincommons.SkinEditionHelper;
import org.ametys.skinfactory.SkinFactoryComponent;
import org.ametys.skinfactory.parameters.AbstractSkinParameter;
import org.ametys.web.skin.SkinModel;
import org.ametys.web.skin.SkinModelsManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.impl.SitemapSource;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.collections.SetUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.dom.DOMParser;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RibbonGenerator
extends ServiceableGenerator {
    private SourceResolver _srcResolver;
    private SkinModelsManager _modelsManager;
    private SkinFactoryComponent _skinFactoryManager;
    private DOMParser _domParser;
    private XPathProcessor _xpathProcessor;
    private SkinEditionHelper _skinHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._srcResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._skinHelper = (SkinEditionHelper)smanager.lookup(SkinEditionHelper.ROLE);
        this._modelsManager = (SkinModelsManager)smanager.lookup(SkinModelsManager.ROLE);
        this._skinFactoryManager = (SkinFactoryComponent)((Object)smanager.lookup(SkinFactoryComponent.ROLE));
        this._domParser = (DOMParser)smanager.lookup(DOMParser.ROLE);
        this._xpathProcessor = (XPathProcessor)smanager.lookup(XPathProcessor.ROLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws IOException, SAXException, ProcessingException {
        String modelName;
        block33: {
            String skinName = this.parameters.getParameter("skinName", null);
            modelName = this._skinHelper.getTempModel(skinName);
            if (modelName == null) {
                throw new IllegalArgumentException("The current skin has no model");
            }
            SkinModel model = this._modelsManager.getModel(modelName);
            if (model == null) {
                throw new IllegalArgumentException("The model '" + modelName + "' does not exit anymore");
            }
            this.contentHandler.startDocument();
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"cms");
            Source src = null;
            try {
                block32: {
                    InputStream is;
                    Path ribbonFile;
                    block34: {
                        ribbonFile = model.getPath().resolve("model/cms-ribbon.xml");
                        if (!Files.exists(ribbonFile, new LinkOption[0])) break block34;
                        if (this._isUpToDate(ribbonFile, modelName)) {
                            SAXParser saxParser = null;
                            try (InputStream is2 = Files.newInputStream(ribbonFile, new OpenOption[0]);){
                                saxParser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
                                saxParser.parse(new InputSource(is2), (ContentHandler)new IgnoreRootHandler(this.contentHandler));
                            }
                            catch (ServiceException e) {
                                try {
                                    throw new ProcessingException("Unable to get a SAX parser", (Throwable)e);
                                }
                                catch (Throwable throwable) {
                                    this.manager.release(saxParser);
                                    throw throwable;
                                }
                            }
                            this.manager.release((Object)saxParser);
                            break block32;
                        } else {
                            src = this._srcResolver.resolveURI("cocoon:/" + modelName + "/update/cms-ribbon.xml");
                            ((SitemapSource)src).toSAX((ContentHandler)new IgnoreRootHandler(this.contentHandler));
                            is = Files.newInputStream(ribbonFile, new OpenOption[0]);
                            try {
                                Files.copy(is, ribbonFile, StandardCopyOption.REPLACE_EXISTING);
                            }
                            finally {
                                if (is != null) {
                                    is.close();
                                }
                            }
                        }
                    }
                    src = this._srcResolver.resolveURI("cocoon:/" + modelName + "/create/cms-ribbon.xml");
                    ((SitemapSource)src).toSAX((ContentHandler)new IgnoreRootHandler(this.contentHandler));
                    is = Files.newInputStream(ribbonFile, new OpenOption[0]);
                    try {
                        Files.copy(is, ribbonFile, new CopyOption[0]);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                if (src == null) break block33;
            }
            catch (Throwable throwable) {
                if (src != null) {
                    this._srcResolver.release(src);
                }
                throw throwable;
            }
            this._srcResolver.release(src);
        }
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"parameters");
        Map<String, AbstractSkinParameter> modelParameters = this._skinFactoryManager.getModelParameters(modelName);
        Iterator<AbstractSkinParameter> iterator = modelParameters.values().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"parameters");
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"cms");
                this.contentHandler.endDocument();
                return;
            }
            AbstractSkinParameter parameter = iterator.next();
            parameter.toSAX(this.contentHandler, modelName);
        }
    }

    private boolean _isUpToDate(Path ribbonFile, String modelName) throws IOException, SAXException {
        HashSet<String> ribbonParams = new HashSet<String>();
        try (InputStream is = Files.newInputStream(ribbonFile, new OpenOption[0]);){
            Document document = this._domParser.parseDocument(new InputSource(is));
            NodeList paramNodes = this._xpathProcessor.selectNodeList((Node)document, "/ribbon/tab/groups/group//parameter");
            for (int i = 0; i < paramNodes.getLength(); ++i) {
                Element consistency = (Element)paramNodes.item(i);
                String id = consistency.getAttribute("id");
                ribbonParams.add(id);
            }
            boolean bl = SetUtils.isEqualSet(ribbonParams, this._skinFactoryManager.getModelParameters(modelName).keySet());
            return bl;
        }
    }
}

