/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.SimpleMenu;
import org.ametys.skinfactory.model.ImportModelActionExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ImportModelClientSideElement
extends SimpleMenu {
    private ImportModelActionExtensionPoint _importModelActionEP;
    private boolean _importMenuItemsInitialized;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._importModelActionEP = (ImportModelActionExtensionPoint)((Object)smanager.lookup(ImportModelActionExtensionPoint.ROLE));
    }

    private synchronized void _resolveImportMenuItems() {
        if (!this._importMenuItemsInitialized) {
            ArrayList<SimpleMenu.UnresolvedItem> unresolvedImportMenuItems = new ArrayList<SimpleMenu.UnresolvedItem>();
            Set importActionIds = this._importModelActionEP.getExtensionsIds();
            if (importActionIds.size() > 1) {
                for (String id : importActionIds) {
                    unresolvedImportMenuItems.add(new SimpleMenu.UnresolvedItem((SimpleMenu)this, id, false, false));
                }
            }
            for (SimpleMenu.UnresolvedItem unresolvedItem : unresolvedImportMenuItems) {
                String id = unresolvedItem.getId();
                ClientSideElement element = this._importModelActionEP.getExtension(id);
                if (unresolvedItem.isPrimary()) {
                    this._primaryMenuItem = element;
                }
                this._menuItems.add(element);
            }
            this._importMenuItemsInitialized = true;
        }
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        Iterator iterator;
        ArrayList<ClientSideElement.Script> scripts = new ArrayList<ClientSideElement.Script>();
        Set importActionIds = this._importModelActionEP.getExtensionsIds();
        if (importActionIds.size() == 0) {
            return scripts;
        }
        if (importActionIds.size() == 1 && (iterator = importActionIds.iterator()).hasNext()) {
            String id = (String)iterator.next();
            ClientSideElement importAction = this._importModelActionEP.getExtension(id);
            return importAction.getScripts(ignoreRights, contextParameters);
        }
        this._resolveImportMenuItems();
        ArrayList scriptFiles = new ArrayList();
        ArrayList cssFiles = new ArrayList();
        HashMap parameters = new HashMap();
        for (ClientSideElement.Script script : super.getScripts(ignoreRights, contextParameters)) {
            scriptFiles.addAll(script.getScriptFiles());
            cssFiles.addAll(script.getCSSFiles());
            parameters.putAll(script.getParameters());
        }
        for (String id : importActionIds) {
            ClientSideElement importAction = this._importModelActionEP.getExtension(id);
            for (ClientSideElement.Script script : importAction.getScripts(ignoreRights, contextParameters)) {
                scriptFiles.addAll(script.getScriptFiles());
                cssFiles.addAll(script.getCSSFiles());
                parameters.putAll(script.getParameters());
            }
        }
        scripts.add(new ClientSideElement.Script(this.getId(), this._script.getScriptClassname(), scriptFiles, cssFiles, parameters));
        return scripts;
    }
}

