/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.parameters;

import java.nio.file.Path;
import java.util.regex.Pattern;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.skinfactory.SkinFactoryComponent;
import org.ametys.skinfactory.parameters.CSSParameter;
import org.ametys.skinfactory.parameters.SkinParameterException;
import org.ametys.web.skin.SkinModel;

public class CSSColorParameter
extends CSSParameter {
    private static final Pattern __HEX_HASH_LESS_PATTERN = Pattern.compile("^([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$");
    private static final Pattern __HEX_PATTERN = Pattern.compile("^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$");
    private SkinModel _model;
    private SkinFactoryComponent _skinFactory;

    public CSSColorParameter(String id, I18nizableText label, I18nizableText description, Path cssFile, String cssProperty, String defaultValue, SkinModel model, SkinFactoryComponent skinFactory) {
        super(id, label, description, cssFile, cssProperty, defaultValue);
        this._model = model;
        this._skinFactory = skinFactory;
    }

    @Override
    public void apply(Path tempDir, Path modelDir, Object value, String lang) throws SkinParameterException {
        String themeId;
        SkinModel.Theme theme;
        Object cValue = (String)value;
        if (((String)cValue).startsWith("color-theme-") && (theme = this._model.getTheme(themeId = this._skinFactory.getColorTheme(tempDir))) != null) {
            int colorIndex = Integer.parseInt(((String)cValue).substring("color-theme-".length()));
            String color = theme.getColor(colorIndex);
            cValue = __HEX_HASH_LESS_PATTERN.matcher(color).matches() ? "#" + color.toUpperCase() : (__HEX_PATTERN.matcher(color).matches() ? color.toUpperCase() : color);
        }
        super.apply(tempDir, modelDir, ((String)cValue).equals("transparent") ? cValue : cValue, lang);
    }
}

