/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This OpenToolButtonController is specific for skin editor
 */
Ext.define('Ametys.plugins.skinfactory.controller.OpenSkinFactoryToolController',
	{
	    extend: 'Ametys.ribbon.element.ui.button.OpenToolButtonController',

		constructor: function(config)
		{
            /**
             * @cfg {String} [action="Ametys.plugins.skinfactory.controller.OpenSkinFactoryToolController._act"
]             * @inheritdoc
             */
			config.action =  config.action || "Ametys.plugins.skinfactory.controller.OpenSkinFactoryToolController._act";
						
			this.callParent(arguments);
		},
		
		statics: {
			/**
			 * This action do open the tool using the given Ametys.tool.ToolFactory id. The following additional configuration are required: #cfg-opentool-id, #cfg-opentool-params.
			 * @param {Ametys.ribbon.element.ui.button.OpenToolButtonController} button This controller.
			 * @protected
			 */
			_act: function (button)
			{
				var toolId = button.getInitialConfig("opentool-id");
				var parameters = button.getInitialConfig("opentool-params") || {};
				
				var tool = null;
				if (Ametys.tool.ToolsManager.getFactory(toolId) instanceof Ametys.tool.factory.UniqueToolFactory)
				{
					 tool = Ametys.tool.ToolsManager.getTool(toolId);
				}
				else if (Ametys.tool.ToolsManager.getFactory(toolId) instanceof Ametys.tool.factory.BasicToolFactory)
				{
					tool = Ametys.tool.ToolsManager.getTool(toolId + "$" + parameters.id);
				}
				
				if (tool != null && this._toolParametersMatch(tool, parameters))
				{
					if (tool.isActivated())
					{
						tool.close();
					}
					else
					{
						tool.focus();
						
						// Manually toggle to true because the user click untoggle the button by default.
						button.toggle(true);
					}
				}
				else
				{
					// Manually untoggle because the tool is not opened directly
					button.toggle(false);
					// Use the Open action to check for concurent access and undergoing modifications on the skin.
					Ametys.plugins.skinfactory.skin.SkinActions.open(toolId, parameters);
				}
			},

			/**
			 * Helper function testing the parameters of a tool against a set a parameters passed as arguments to the function.
			 * @param {Ametys.tool.Tool} tool the tool to test
			 * @param {Object} parameters An association parameters name and value (as strings) 
			 * @return {Boolean} `true` if for each parameter passed as arguments the tool has a parameter with the same name (key) and the same value. 
			 * @private
			 */
			_toolParametersMatch: function(tool, parameters)
			{
				parameters = parameters || {};
				var match = true;
				
				Ext.Object.each(parameters, function(key, value) {
					if (tool.getParams()[key] != value)
					{
						match = false;
					}
					
					// stop iteration when match is false.
					return match;
				});
				
				return match;
			}
		}
	}
);
