/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Model menu button for the list of models in the skin
 */
Ext.define('Ametys.plugins.skinfactory.ribbon.menu.ModelMenu', {
	extend: 'Ametys.ribbon.element.ui.ButtonController',
	
	createUI: function(size, colspan)
	{
		var element = this.callParent(arguments);

		element.on("menushow", this._onMenuShow, this);
		
		return element;
	},
		
	/**
	 * Listener for the "menushow" event. Select and show the models
	 * @param {Ext.button.Button} button The button that launched the event.
	 * @param {Ext.menu.Menu} menu The menu that is displayed.
	 */
	_onMenuShow: function (button, menu)
	{
		var me = this;
		var currentModel = Ametys.plugins.skinfactory.SkinParametersManager.getCurrentModel();
		
        this._getGalleries(button).each(function(gallery) {
            gallery.items.each(function (item) {
    			var controller = Ametys.ribbon.RibbonManager.getUI(item.controlId);
    			var modelName = controller.getInitialConfig("modelName");
    			item.toggle(currentModel == modelName, true);
            });
        });
	}
});
