/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Item with menu for the css style depending widgets
 */
Ext.define('Ametys.plugins.skinfactory.widgets.item.CssStyleWidgetItem', {
	extend: 'Ext.menu.Item',
	
	constructor: function (config) 
	{
		this.callParent(arguments);
		
		var menuCfg = {paramId: config.paramId};
		if (config.cssStyle)
		{
			menuCfg.cssStyle = config.cssStyle;
		}
		var menu = Ext.create(config.menuClass || "Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu", menuCfg);
		
		this.setMenu(menu);
	}
});
