/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Item for the italic font style in the parameter menu
 */
Ext.define('Ametys.plugins.skinfactory.widgets.item.FontStyleItalicItem', {
	extend: 'Ext.menu.CheckItem',
	
	constructor: function (config) 
	{
		// Default config
		config = Ext.applyIf(config, {
			text: "{{i18n PLUGINS_SKINFACTORY_FONTSTYLE_ITALIC}}",
			iconCls: 'ametysicon-italic8'
			//cls: 'italic'
		});
		
		this.callParent(arguments);
		
		this.on("checkchange", this._onCheckChange, this);
	},
	
	/**
	 * Listener for the check change event. Update the parameter value.
	 * @param {Ext.menu.Item} item The current item
	 * @param {boolean} checked The state of the item
	 */
	_onCheckChange: function (item, checked)
	{
		var value= checked ? 'italic' : 'normal';
		Ametys.plugins.skinfactory.skin.SkinActions.updateParameter(this.getInitialConfig("paramId"), value);
	}
});
